/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.style;

import com.deutscheboerse.comxerv.comtrader.jfx.service.style.ColorThemeService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.FontService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.StyleService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.Scene;
import javafx.stage.Window;

@Singleton
public class StyleServiceImpl
implements StyleService {
    private final FontService fontService;
    private final ColorThemeService colorThemeService;
    private final ChangeListener<Scene> sceneChangeListener;

    @Inject
    public StyleServiceImpl(FontService fontService, ColorThemeService colorThemeService) {
        this.fontService = fontService;
        this.colorThemeService = colorThemeService;
        this.sceneChangeListener = (observable2, oldValue, newValue) -> this.registerSceneForStyleSwitching((Scene)newValue);
    }

    @Override
    public void registerWindowForStyleSwitching(Window window) {
        window.sceneProperty().addListener(new WeakChangeListener<Scene>(this.sceneChangeListener));
        this.registerSceneForStyleSwitching(window.getScene());
    }

    @Override
    public void registerSceneForStyleSwitching(Scene scene) {
        if (scene != null) {
            this.fontService.registerSceneForFontSwitching(scene);
            this.colorThemeService.registerSceneForThemeSwitching(scene);
        }
    }
}

