/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.async;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class ActionWithTimeout {
    private final Action action;
    private final long timeout;
    private final Runnable timeoutHandler;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AtomicReference<ActionState> state;

    public ActionWithTimeout(Action action, long timeout, Runnable timeoutHandler, ScheduledExecutorService scheduledExecutorService) {
        this.action = action;
        this.timeout = timeout;
        this.timeoutHandler = timeoutHandler;
        this.scheduledExecutorService = scheduledExecutorService;
        this.state = new AtomicReference<ActionState>(ActionState.READY);
    }

    private void timeoutReached() {
        if (this.state.compareAndSet(ActionState.RUNNING, ActionState.TIMEOUT_REACHED)) {
            this.timeoutHandler.run();
        }
    }

    private void execute() {
        if (!this.state.compareAndSet(ActionState.READY, ActionState.RUNNING)) {
            throw new IllegalStateException("This action has already been run.");
        }
        this.scheduledExecutorService.schedule(this::timeoutReached, this.timeout, TimeUnit.MILLISECONDS);
        this.action.runAction(this::actionFinished);
    }

    public void executeAsynchronously() {
        if (this.state.get() != ActionState.READY) {
            throw new IllegalStateException("This action has already been run.");
        }
        this.scheduledExecutorService.execute(this::execute);
    }

    private ActionState actionFinished() {
        if (this.state.compareAndSet(ActionState.RUNNING, ActionState.FINISHED)) {
            return ActionState.FINISHED;
        }
        return ActionState.TIMEOUT_REACHED;
    }

    @FunctionalInterface
    public static interface Action {
        public void runAction(ActionFinishedCallback var1);
    }

    public static enum ActionState {
        READY,
        RUNNING,
        FINISHED,
        TIMEOUT_REACHED;

    }

    @FunctionalInterface
    public static interface ActionFinishedCallback {
        public ActionState actionFinished();
    }
}

