/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.common;

import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ErrorCollector {
    private List<Error> errors = Lists.newArrayList();

    public void addError(String explanation, int lineNr, int columnNr, String columnName) {
        if (this.errors.stream().noneMatch(e -> e.columnNr == columnNr && e.lineNr == lineNr)) {
            this.errors.add(new Error(explanation, lineNr, columnNr, columnName));
        }
    }

    public void addError(String message, int lineNr) {
        this.addError(message, lineNr, -1, null);
    }

    public void addError(String message) {
        this.addError(message, -1, -1, null);
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    public int numberOfErrors() {
        return this.errors.size();
    }

    public String prepareErrorsForPopup() {
        StringBuilder popupString = new StringBuilder();
        Collections.sort(this.errors, new ErrorComparator());
        for (Error error : this.errors) {
            if (error.getLineNr() != -1 && error.getColumnNr() != -1 && error.getColumnName() != null) {
                popupString.append(Util.getLabel("importException_errorLineAll", error.getLineNr(), error.getColumnNr(), error.getColumnName(), error.getMessage())).append('\n');
                continue;
            }
            if (error.getLineNr() != -1) {
                popupString.append(Util.getLabel("importException_errorLineLineOnly", error.getLineNr(), error.getMessage())).append('\n');
                continue;
            }
            popupString.append(error.getMessage()).append('\n');
        }
        return popupString.toString();
    }

    private static final class Error {
        private String message;
        private String columnName;
        private int lineNr;
        private int columnNr;

        public Error(String message, int lineNr, int columnNr, String columnName) {
            this.message = message;
            this.lineNr = lineNr;
            this.columnNr = columnNr;
            this.columnName = columnName;
        }

        public String getMessage() {
            return this.message;
        }

        public int getLineNr() {
            return this.lineNr;
        }

        public int getColumnNr() {
            return this.columnNr;
        }

        public String getColumnName() {
            return this.columnName;
        }
    }

    private static final class ErrorComparator
    implements Comparator<Error> {
        private ErrorComparator() {
        }

        @Override
        public int compare(Error error1, Error error2) {
            if (error1.lineNr != error2.lineNr) {
                return error1.lineNr - error2.lineNr;
            }
            return error1.columnNr - error2.columnNr;
        }
    }
}

