/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.DeliveryAreaColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Arrays;
import java.util.Collection;

public class OrderDeliveryAreaColumn
extends DeliveryAreaColumn<Order>
implements ImportColumn<DeliveryArea, Order> {
    public OrderDeliveryAreaColumn(String header, ApplicationContext appContext) {
        super(header, appContext);
    }

    @Override
    public DeliveryArea getValue(Order objectToExport) {
        return objectToExport.getDeliveryArea();
    }

    @Override
    public DeliveryArea parseValue(String data) throws ImportException {
        DeliveryArea deliveryArea = this.parseDeliveryAreaValue(data);
        if (deliveryArea != null || data.isEmpty()) {
            return deliveryArea;
        }
        throw new ImportException("Unknown bidding area.", Util.getLabel("orderValidationError_invalidDA") + " " + data);
    }

    @Override
    public void applyValue(DeliveryArea value, Order importedObject) {
        importedObject.setDeliveryArea(value);
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Arrays.asList(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_DA.getMessageKey());
    }
}

