/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.listener;

import com.deutscheboerse.comxerv.comtrader.core.datamodel.EntityListener;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BroadcastListenerHandlerForClassImpl
implements BroadcastListenerHandlerForClass {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastListenerHandlerForClassImpl.class);
    private final Map<Class, List<EntityListener>> listenerMap = new ConcurrentHashMap<Class, List<EntityListener>>();

    @Override
    public void notifyListeners(BroadcastEntity entity) {
        if (entity == null) {
            return;
        }
        List<EntityListener> listeners = this.listenerMap.get(entity.getEntityClass());
        if (listeners != null) {
            for (EntityListener listener : listeners) {
                listener.handleBroadcastEntity(entity);
            }
        } else {
            LOG.warn("listeners not found for entity {}", (Object)entity);
        }
    }

    @Override
    public void notifyListeners(Collection<? extends BroadcastEntity> collection) {
        HashMap<Class, List> map = new HashMap<Class, List>();
        for (BroadcastEntity broadcastEntity : collection) {
            map.computeIfAbsent(broadcastEntity.getEntityClass(), key -> new ArrayList()).add(broadcastEntity);
        }
        for (Map.Entry entry : map.entrySet()) {
            List<EntityListener> listeners = this.listenerMap.get(entry.getKey());
            if (listeners != null) {
                for (EntityListener listener : listeners) {
                    listener.handleBroadcastEntities((Collection)entry.getValue());
                }
                continue;
            }
            LOG.warn("listeners not found for class {}", entry.getKey());
        }
    }

    @Override
    public void registerBackendBroadcastListener(EntityListener<? extends BroadcastEntity> entityListener) {
        this.listenerMap.computeIfAbsent(entityListener.getEntityClass(), key -> new ArrayList()).add(entityListener);
    }

    public boolean unregisterBackendBroadcastListener(EntityListener backendBroadcastListener) {
        List<EntityListener> listeners = this.listenerMap.get(backendBroadcastListener.getEntityClass());
        if (listeners != null) {
            return listeners.remove(backendBroadcastListener);
        }
        return false;
    }
}

