/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry.emergency;

import com.deutscheboerse.comxerv.comtrader.domain.query.OrderQueries;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSender;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.emergency.EmergencyService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class EmergencyServiceImpl
implements EmergencyService {
    private final UserAlertService userAlertService;
    private final OrderSender orderSender;
    private final UserService userService;
    private final OrderQueries orderQueries;

    @Inject
    public EmergencyServiceImpl(UserAlertService userAlertService, OrderSender orderSender, UserService userService, OrderQueries orderQueries) {
        this.userAlertService = userAlertService;
        this.orderSender = orderSender;
        this.userService = userService;
        this.orderQueries = orderQueries;
    }

    @Override
    public void activateAllHibernated() {
        if (this.ask("commons_activateAllQuestion", "emergencyService_activateAllForExchange_question")) {
            this.sendEmergencyOrder(RequestType.ACTIVATE, true, ResponseHandler.EMPTY);
        }
    }

    @Override
    public void deleteAll() {
        if (this.ask("commons_cancelAllQuestion", "emergencyService_cancelAllForExchange_question")) {
            this.deleteAllWithoutQuestion(true, ResponseHandler.EMPTY);
        }
    }

    @Override
    public void hibernateAllActive() {
        if (this.ask("commons_deactivateAllQuestion", "emergencyService_deactivateAllForExchange_question")) {
            this.hibernateAllActiveWithoutQuestion(true, ResponseHandler.EMPTY);
        }
    }

    @Override
    public void deleteAllWithoutQuestion(boolean considerOnbehalf, ResponseHandler responseHandler) {
        CompoundResponseHandler compoundResponseHandler = new CompoundResponseHandler(responseHandler, "emergencyService_cancelAllSuccessMessage", "emergencyService_cancelAllFailedMessage");
        if (this.deleteOrders(considerOnbehalf, compoundResponseHandler)) {
            compoundResponseHandler.expectResponse();
        }
        compoundResponseHandler.handleResponseHandlerIfNoResponsesExpected();
    }

    private boolean deleteOrders(boolean considerOnbehalf, CompoundResponseHandler compoundResponseHandler) {
        if (this.orderQueries.findActiveOrders().getFirst().isPresent() || this.orderQueries.findHibernateOrders().getFirst().isPresent()) {
            this.sendEmergencyOrder(RequestType.DELETE, considerOnbehalf, compoundResponseHandler);
            return true;
        }
        return false;
    }

    @Override
    public void hibernateAllActiveWithoutQuestion(boolean considerOnbehalf, ResponseHandler responseHandler) {
        CompoundResponseHandler compoundResponseHandler = new CompoundResponseHandler(responseHandler, "emergencyService_deactivateAllSuccessMessage", "emergencyService_deactivateAllFailedMessage");
        if (this.hibernateOrders(considerOnbehalf, compoundResponseHandler)) {
            compoundResponseHandler.expectResponse();
        }
        compoundResponseHandler.handleResponseHandlerIfNoResponsesExpected();
    }

    private boolean hibernateOrders(boolean considerOnbehalf, CompoundResponseHandler compoundResponseHandler) {
        if (this.orderQueries.findActiveOrders().getFirst().isPresent()) {
            this.sendEmergencyOrder(RequestType.DEACTIVATE, considerOnbehalf, compoundResponseHandler);
            return true;
        }
        return false;
    }

    private void sendEmergencyOrder(RequestType requestType, boolean considerOnBehalf, ResponseHandler responseHandler) {
        this.orderSender.sendEmergencyOrder(((User)this.userService.currentUserProperty().get()).getExchange(), requestType, considerOnBehalf, responseHandler);
    }

    private boolean ask(String questionHeaderLabelKey, String questionTextLabelKey) {
        String questionHeader = Util.getLabel(questionHeaderLabelKey);
        String questionText = Util.getLabel(questionTextLabelKey);
        return this.userAlertService.showQuestionDialog(questionHeader, questionText, UserAlertService.Flag.OK_CANCEL);
    }

    private static final class CompoundResponseHandler
    implements ResponseHandler {
        private final ResponseHandler parentHandler;
        private final String successMessageKey;
        private final String errorMessageKey;
        private boolean anyErrors;
        private int expectedResponses;

        public CompoundResponseHandler(ResponseHandler parentHandler, String successMessageKey, String errorMessageKey) {
            this.parentHandler = parentHandler;
            this.successMessageKey = successMessageKey;
            this.errorMessageKey = errorMessageKey;
            this.expectedResponses = 0;
            this.anyErrors = false;
        }

        private void expectResponse() {
            ++this.expectedResponses;
        }

        public void handleResponseHandlerIfNoResponsesExpected() {
            if (this.expectedResponses == 0) {
                this.parentHandler.handleResponse(new AsyncResponse(ResponseStatus.SUCCESS, null));
            }
        }

        @Override
        public void handleResponse(AsyncResponse response) {
            this.anyErrors |= response.getStatus() == ResponseStatus.ERROR;
            if (--this.expectedResponses == 0) {
                ResponseStatus status = this.anyErrors ? ResponseStatus.ERROR : ResponseStatus.SUCCESS;
                String message = this.anyErrors ? Util.getLabel(this.errorMessageKey) : Util.getLabel(this.successMessageKey);
                this.parentHandler.handleResponse(new AsyncResponse(status, null, message, null));
            }
        }
    }
}

