/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry.preference;

import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.SerializableOrderPreferencesEntry;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class OrderPreferencesEntry {
    private final StringProperty product;
    private final StringProperty contract;
    private final ObjectProperty<LongDisplayValue> quantity;
    private final ObjectProperty<OrderType> orderType;
    private final ObjectProperty<DeliveryArea> deliveryArea;
    private final StringProperty accountType;
    private final ObjectProperty<ValidityRestriction> validityRestriction;
    private final ObjectProperty<OpenOrClose> openOrClose;

    public OrderPreferencesEntry() {
        this.product = new SimpleStringProperty();
        this.contract = new SimpleStringProperty();
        this.quantity = new SimpleObjectProperty<LongDisplayValue>(new LongDisplayValue());
        this.orderType = new SimpleObjectProperty<OrderType>(OrderType.REGULAR);
        this.deliveryArea = new SimpleObjectProperty<DeliveryArea>();
        this.accountType = new SimpleStringProperty();
        this.validityRestriction = new SimpleObjectProperty<ValidityRestriction>(ValidityRestriction.GOOD_FOR_SESSION);
        this.openOrClose = new SimpleObjectProperty<OpenOrClose>(OpenOrClose.OPEN);
    }

    public OrderPreferencesEntry(DataModel<String, DeliveryArea> deliveryAreaDataModel, SerializableOrderPreferencesEntry serializableOrderPreferencesEntry) {
        this.product = new SimpleStringProperty(serializableOrderPreferencesEntry.getProduct());
        this.contract = new SimpleStringProperty(serializableOrderPreferencesEntry.getContract());
        this.quantity = new SimpleObjectProperty<LongDisplayValue>(serializableOrderPreferencesEntry.getQuantity());
        this.orderType = new SimpleObjectProperty<OrderType>(serializableOrderPreferencesEntry.getOrderType());
        this.deliveryArea = new SimpleObjectProperty<DeliveryArea>(deliveryAreaDataModel.findById(serializableOrderPreferencesEntry.getDeliveryAreaId()));
        this.accountType = new SimpleStringProperty(serializableOrderPreferencesEntry.getAccountType());
        this.validityRestriction = new SimpleObjectProperty<ValidityRestriction>(serializableOrderPreferencesEntry.getValidityRestriction());
        this.openOrClose = new SimpleObjectProperty<OpenOrClose>(serializableOrderPreferencesEntry.getOpenOrClose());
    }

    public String getProduct() {
        return (String)this.product.get();
    }

    public StringProperty productProperty() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product.set(product);
    }

    public String getContract() {
        return (String)this.contract.get();
    }

    public StringProperty contractProperty() {
        return this.contract;
    }

    public void setContract(String contract) {
        this.contract.set(contract);
    }

    public LongDisplayValue getQuantity() {
        return (LongDisplayValue)this.quantity.get();
    }

    public ObjectProperty<LongDisplayValue> quantityProperty() {
        return this.quantity;
    }

    public void setQuantity(LongDisplayValue quantity) {
        this.quantity.set(quantity);
    }

    public OrderType getOrderType() {
        return (OrderType)this.orderType.get();
    }

    public ObjectProperty<OrderType> orderTypeProperty() {
        return this.orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType.set(orderType);
    }

    public DeliveryArea getDeliveryArea() {
        return (DeliveryArea)this.deliveryArea.get();
    }

    public ObjectProperty<DeliveryArea> deliveryAreaProperty() {
        return this.deliveryArea;
    }

    public void setDeliveryArea(DeliveryArea deliveryArea) {
        this.deliveryArea.set(deliveryArea);
    }

    public String getAccountType() {
        return (String)this.accountType.get();
    }

    public StringProperty accountTypeProperty() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType.set(accountType);
    }

    public ValidityRestriction getValidityRestriction() {
        return (ValidityRestriction)this.validityRestriction.get();
    }

    public ObjectProperty<ValidityRestriction> validityRestrictionProperty() {
        return this.validityRestriction;
    }

    public void setValidityRestriction(ValidityRestriction validityRestriction) {
        this.validityRestriction.set(validityRestriction);
    }

    public OpenOrClose getOpenOrClose() {
        return (OpenOrClose)this.openOrClose.get();
    }

    public ObjectProperty<OpenOrClose> openOrCloseProperty() {
        return this.openOrClose;
    }

    public void setOpenOrClose(OpenOrClose openOrClose) {
        this.openOrClose.set(openOrClose);
    }
}

