/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.statistic;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.domain.query.HalfTradeQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.statistic.OwnVolumeStatistics;
import com.deutscheboerse.comxerv.comtrader.service.statistic.OwnVolumeStatisticsValues;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.Nonnull;

public class OwnVolumeStatisticsImpl
implements OwnVolumeStatistics,
DataModelListener<FullTrade> {
    private static final String SYSTEM_MEMBERID = "SYSTM";
    private static final int UPDATE_DELAY = 1000;
    private final AtomicBoolean updating;
    private final ApplicationContext ctx;
    private final UserService userService;
    private final DataModel<Long, FullTrade> fullTradeDataModel;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ObjectProperty<LongDisplayValue> totalOwnPurchaseQuantity;
    private final ObjectProperty<LongDisplayValue> totalOwnSellQuantity;
    private final ObjectProperty<LongDisplayValue> averageOwnPurchasePrice;
    private final ObjectProperty<LongDisplayValue> averageOwnSellPrice;
    private LongDisplayValue ownPurchaseQuantityByPriceMultiplicationProduct;
    private LongDisplayValue ownSellQuantityByPriceMultiplicationProduct;
    private final Contract contract;
    private final DeliveryArea deliveryArea;
    private final String memberId;

    public OwnVolumeStatisticsImpl(Orderbook orderbook, ApplicationContext applicationContext) {
        this.ctx = applicationContext;
        this.userService = this.ctx.getService(UserService.class);
        this.fullTradeDataModel = this.ctx.getDataModel(FullTrade.class);
        this.scheduledExecutorService = this.ctx.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.updating = new AtomicBoolean(false);
        this.totalOwnPurchaseQuantity = new SimpleObjectProperty<LongDisplayValue>();
        this.totalOwnSellQuantity = new SimpleObjectProperty<LongDisplayValue>();
        this.averageOwnPurchasePrice = new SimpleObjectProperty<LongDisplayValue>();
        this.averageOwnSellPrice = new SimpleObjectProperty<LongDisplayValue>();
        this.contract = orderbook.getContract();
        this.deliveryArea = orderbook.getDeliveryArea();
        this.memberId = this.userService.getCurrentUser().getMemberId();
        if (!this.userService.getOwnUser().getRoles().isAdmin()) {
            this.calculateValues();
            this.fullTradeDataModel.registerHencePreOperationListener(new WeakDataModelListener<FullTrade>(this));
        }
    }

    private void startCalculateValues() {
        if (this.updating.compareAndSet(false, true)) {
            this.scheduledExecutorService.schedule(FxUtil.wrapWithRunInFxThread(this::calculateValues), 1000L, TimeUnit.MILLISECONDS);
        }
    }

    private void calculateValues() {
        DataQuery<HalfTrade> halfTradeDataQuery = this.ctx.getService(HalfTradeQueries.class).findByContractDeliveryAreaAndMemberId(this.contract, this.deliveryArea, this.memberId).addFilter(this::checkIfItIsMyHalfTrade);
        OwnVolumeStatisticsValues values2 = new OwnVolumeStatisticsValues(halfTradeDataQuery.getAll().filter(halfTrade -> !halfTrade.isRemoved()));
        this.ownPurchaseQuantityByPriceMultiplicationProduct = values2.getOwnPurchaseQuantityByPriceMultiplicationProduct();
        this.ownSellQuantityByPriceMultiplicationProduct = values2.getOwnSellQuantityByPriceMultiplicationProduct();
        this.totalOwnPurchaseQuantity.set(values2.getTotalOwnPurchaseQuantity());
        this.totalOwnSellQuantity.set(values2.getTotalOwnSellQuantity());
        this.averageOwnPurchasePrice.set(this.calculateAverage(this.ownPurchaseQuantityByPriceMultiplicationProduct, this.totalOwnPurchaseQuantity));
        this.averageOwnSellPrice.set(this.calculateAverage(this.ownSellQuantityByPriceMultiplicationProduct, this.totalOwnSellQuantity));
        this.updating.set(false);
    }

    private LongDisplayValue calculateAverage(LongDisplayValue multiplicationProduct, ObjectProperty<LongDisplayValue> quantity) {
        if (multiplicationProduct == null || quantity == null || quantity.get() == null || ((LongDisplayValue)quantity.get()).getValue() == 0L) {
            return null;
        }
        return new LongDisplayValue(multiplicationProduct.getDisplayValue().divide(((LongDisplayValue)quantity.get()).getDisplayValue(), RoundingMode.HALF_UP));
    }

    @Override
    public LongDisplayValue getTotalOwnPurchaseQuantity() {
        return (LongDisplayValue)this.totalOwnPurchaseQuantity.get();
    }

    @Override
    public ReadOnlyObjectProperty<LongDisplayValue> totalOwnPurchaseQuantityProperty() {
        return this.totalOwnPurchaseQuantity;
    }

    @Override
    public LongDisplayValue getTotalOwnSellQuantity() {
        return (LongDisplayValue)this.totalOwnSellQuantity.get();
    }

    @Override
    public ReadOnlyObjectProperty<LongDisplayValue> totalOwnSellQuantityProperty() {
        return this.totalOwnSellQuantity;
    }

    @Override
    public LongDisplayValue getAverageOwnPurchasePrice() {
        return (LongDisplayValue)this.averageOwnPurchasePrice.get();
    }

    @Override
    public ReadOnlyObjectProperty<LongDisplayValue> averageOwnPurchasePriceProperty() {
        return this.averageOwnPurchasePrice;
    }

    @Override
    public LongDisplayValue getAverageOwnSellPrice() {
        return (LongDisplayValue)this.averageOwnSellPrice.get();
    }

    @Override
    public ReadOnlyObjectProperty<LongDisplayValue> averageOwnSellPriceProperty() {
        return this.averageOwnSellPrice;
    }

    @Override
    public DataModelListener.NotificationResult notifyAdd(FullTrade trade) {
        return this.notifyChange(trade);
    }

    private boolean checkHasMyHalfTrade(FullTrade trade) {
        return this.checkIfItIsMyHalfTrade(trade.getBuyHalfTrade()) || this.checkIfItIsMyHalfTrade(trade.getSellHalfTrade());
    }

    @Override
    public DataModelListener.NotificationResult notifyAddAll(Collection<FullTrade> trades) {
        trades.forEach(this::notifyAdd);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemove(FullTrade trade) {
        return this.notifyChange(trade);
    }

    @Override
    public DataModelListener.NotificationResult notifyRemoveAll(Collection<FullTrade> trades) {
        trades.forEach(this::notifyRemove);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemoveAll() {
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdate(FullTrade trade) {
        return this.notifyChange(trade);
    }

    @Nonnull
    private DataModelListener.NotificationResult notifyChange(FullTrade trade) {
        if (this.checkHasMyHalfTrade(trade)) {
            this.startCalculateValues();
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdateAll(Collection<FullTrade> trades) {
        trades.forEach(this::notifyUpdate);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private boolean checkIfItIsMyHalfTrade(HalfTrade halfTrade) {
        return halfTrade != null && this.contract.equals(halfTrade.getContract()) && ((String)this.deliveryArea.getId()).equals(halfTrade.getOrder().getDeliveryAreaId()) && this.memberId.equals(halfTrade.getMemberId()) && this.isStatitisticsRelevant(halfTrade);
    }

    private boolean isStatitisticsRelevant(HalfTrade halfTrade) {
        if (halfTrade.getParentTradeId() == null) {
            return true;
        }
        FullTrade parentTrade = this.fullTradeDataModel.findById(halfTrade.getParentTradeId());
        if (parentTrade == null) {
            return true;
        }
        HalfTrade parentHalf = parentTrade.getHalf(halfTrade.getDirection());
        return parentHalf == null || SYSTEM_MEMBERID.equals(parentHalf.getMemberId());
    }
}

