/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.trade;

import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeProcessingUserInterface;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TradeProcessResponseProcessor {
    public void process(AsyncResponse var1);

    public static class TradeCancelResponseProcessor
    implements TradeProcessResponseProcessor {
        private static final Logger LOG = LoggerFactory.getLogger(TradeCancelResponseProcessor.class);
        private final TradeProcessingUserInterface tradePopupService;
        private final List<FullTrade> tradesToCancel;
        private final AtomicInteger received = new AtomicInteger(0);
        private final AtomicInteger errors = new AtomicInteger(0);

        public TradeCancelResponseProcessor(TradeProcessingUserInterface tradePopupService, List<FullTrade> tradesToCancel) {
            this.tradePopupService = tradePopupService;
            this.tradesToCancel = tradesToCancel;
        }

        @Override
        public void process(AsyncResponse response) {
            this.increaseCounters(response);
            if (this.received.get() == this.tradesToCancel.size()) {
                int failures = this.errors.get();
                int cancelled = this.received.get() - failures;
                LOG.info("All trade-cancel resp. Cancelled: {}, failures: {}.", (Object)cancelled, (Object)failures);
                this.tradePopupService.showTradesCancelledPopup(this.tradesToCancel, cancelled, failures);
            }
        }

        private void increaseCounters(AsyncResponse response) {
            if (response.getStatus() == ResponseStatus.ACKNOWLEDGED) {
                return;
            }
            this.received.incrementAndGet();
            if (response.getStatus() == ResponseStatus.ERROR) {
                this.errors.incrementAndGet();
            }
        }
    }

    public static class TradeRecallResponseProcessor
    implements TradeProcessResponseProcessor {
        @Override
        public void process(AsyncResponse response) {
        }
    }
}

