/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util;

import com.deutscheboerse.comxerv.comtrader.util.EventDebugger;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.eventbus.EventBus;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedEventBus
extends EventBus {
    private static final Logger LOG = LoggerFactory.getLogger(EventBus.class);

    public ExtendedEventBus(String name) {
        super(name);
        this.register(new EventDebugger());
    }

    public ExtendedEventBus() {
        this.register(new EventDebugger());
    }

    @Override
    public void register(Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("EventBus.register {} {}", (Object)object.getClass().getName(), (Object)System.identityHashCode(object));
        }
        super.register(object);
    }

    @Override
    public void unregister(Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("EventBus.unregister {} {}", (Object)object.getClass().getName(), (Object)System.identityHashCode(object));
        }
        try {
            super.unregister(object);
        }
        catch (IllegalArgumentException exc) {
            LOG.debug("Try to unregister more than once the object from EventBus", exc);
        }
    }

    @Override
    public void post(Object event) {
        if (Platform.isFxApplicationThread()) {
            super.post(event);
        } else {
            try {
                FxUtil.invokeAndWait(() -> super.post(event), 10000L);
            }
            catch (Exception e) {
                LOG.error("", e);
            }
        }
    }
}

