/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CountDownTimer {
    private final Runnable timeoutAction;
    private final ScheduledFuture<?> scheduledFuture;

    public CountDownTimer(long timeoutMillis, Runnable timeoutAction, ScheduledExecutorService executorService) {
        this.timeoutAction = timeoutAction;
        this.scheduledFuture = executorService.schedule(this::timeoutReached, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    private void timeoutReached() {
        if (!this.scheduledFuture.isCancelled()) {
            this.timeoutAction.run();
        }
    }

    public void abort() {
        this.scheduledFuture.cancel(false);
    }
}

