/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util.concurrent;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class SlicedRunnable<T>
implements Runnable {
    protected final String taskName;
    protected final Collection<T> sliceInputs;

    public SlicedRunnable(String taskName, Collection<T> sliceInputs) {
        this.taskName = taskName;
        this.sliceInputs = sliceInputs;
    }

    protected void handleExceptions(CopyOnWriteArrayList<RuntimeException> exceptions) {
        if (!exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw new IllegalStateException(exceptions.get(0));
            }
            StringBuilder sb = new StringBuilder("Multiple slice executions failed, the first stacktrace is attached.");
            for (RuntimeException e : exceptions) {
                sb.append("\n");
                sb.append(e.getMessage());
            }
            throw new IllegalStateException(sb.toString(), exceptions.get(0));
        }
    }

    public String toString() {
        return "Sliced task (" + this.taskName + ")";
    }
}

