/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingRunnable
implements Runnable {
    private final Runnable delegate;
    private final Exception originalContext;
    private static final Logger LOG = LoggerFactory.getLogger(LoggingRunnable.class);

    public LoggingRunnable(Runnable delegate) {
        this.delegate = delegate;
        this.originalContext = new Exception();
    }

    @Override
    public void run() {
        try {
            this.delegate.run();
        }
        catch (Exception e) {
            this.originalContext.initCause(e);
            LOG.error("Error during execution of " + this.delegate.toString(), this.originalContext);
            throw e;
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

