/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.binding;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.expression.Resolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectByGetters<S, T> {
    private static final Logger LOG = LoggerFactory.getLogger(SelectByGetters.class);
    private static final PropertyUtilsBean propertyUtilsBean = BeanUtilsBean.getInstance().getPropertyUtils();
    private static final Resolver resolver = propertyUtilsBean.getResolver();
    private final String path;
    private Method[] getterMethods;
    private Class<?> lastClass;

    public SelectByGetters(String path) {
        this.path = path;
    }

    public T evaluate(S s) {
        if (s == null) {
            return null;
        }
        try {
            if (this.getterMethods == null || this.lastClass != s.getClass()) {
                this.readGetterMethods(s.getClass());
            }
            return this.evaluateReflective(s);
        }
        catch (NestedNullException ex) {
            return null;
        }
        catch (IllegalAccessException | IllegalStateException | NoSuchMethodException | InvocationTargetException e) {
            LOG.debug("Property access error - cannot get " + this.path + " of " + String.valueOf(s) + " using static types.", e);
            return this.evaluateDynamically(s);
        }
    }

    private void readGetterMethods(Class<?> rootClass) throws NoSuchMethodException {
        this.lastClass = rootClass;
        ArrayList<Method> methods = new ArrayList<Method>();
        String name = this.path;
        Class<?> beanClass = rootClass;
        while (resolver.hasNested(name)) {
            String next = resolver.next(name);
            this.checkUnsupportedProperties(resolver, next);
            PropertyDescriptor propertyDescriptor = this.readPropertyDescriptor(beanClass, next);
            methods.add(propertyDescriptor.getReadMethod());
            beanClass = propertyDescriptor.getPropertyType();
            name = resolver.remove(name);
        }
        this.checkUnsupportedProperties(resolver, name);
        PropertyDescriptor propertyDescriptor = this.readPropertyDescriptor(beanClass, name);
        methods.add(propertyDescriptor.getReadMethod());
        this.getterMethods = methods.toArray(new Method[methods.size()]);
    }

    private void checkUnsupportedProperties(Resolver resolver2, String name) {
        if (resolver2.isMapped(name)) {
            throw new IllegalStateException("Mapped properties are not supported.");
        }
        if (resolver2.isIndexed(name)) {
            throw new IllegalStateException("Indexed properties are not supported.");
        }
    }

    private PropertyDescriptor readPropertyDescriptor(Class<?> beanClass, String propertyName) throws NoSuchMethodException {
        for (PropertyDescriptor propertyDescriptor : propertyUtilsBean.getPropertyDescriptors(beanClass)) {
            if (!propertyDescriptor.getName().equals(propertyName)) continue;
            return propertyDescriptor;
        }
        throw new NoSuchMethodException("Unknown property '" + propertyName + "' on class '" + String.valueOf(beanClass) + "'");
    }

    private T evaluateReflective(S s) throws IllegalAccessException, InvocationTargetException, NestedNullException {
        Object o = s;
        for (Method getterMethod : this.getterMethods) {
            if (o == null) {
                throw new NestedNullException();
            }
            o = getterMethod.invoke(o, new Object[0]);
        }
        return (T)o;
    }

    public T evaluateDynamically(S s) {
        try {
            return (T)propertyUtilsBean.getNestedProperty(s, this.path);
        }
        catch (NestedNullException e) {
            return null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Property access error - cannot get " + this.path + " of " + String.valueOf(s), e);
            return null;
        }
    }
}

