/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.queue.PredicatedQueue;
import org.apache.commons.collections4.queue.SynchronizedQueue;
import org.apache.commons.collections4.queue.TransformedQueue;
import org.apache.commons.collections4.queue.UnmodifiableQueue;

public class QueueUtils {
    public static final Queue EMPTY_QUEUE = UnmodifiableQueue.unmodifiableQueue(new LinkedList());

    public static <E> Queue<E> emptyQueue() {
        return EMPTY_QUEUE;
    }

    public static <E> Queue<E> predicatedQueue(Queue<E> queue2, Predicate<? super E> predicate) {
        return PredicatedQueue.predicatedQueue(queue2, predicate);
    }

    public static <E> Queue<E> synchronizedQueue(Queue<E> queue2) {
        return SynchronizedQueue.synchronizedQueue(queue2);
    }

    public static <E> Queue<E> transformingQueue(Queue<E> queue2, Transformer<? super E, ? extends E> transformer) {
        return TransformedQueue.transformingQueue(queue2, transformer);
    }

    public static <E> Queue<E> unmodifiableQueue(Queue<? extends E> queue2) {
        return UnmodifiableQueue.unmodifiableQueue(queue2);
    }

    private QueueUtils() {
    }
}

