/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.factory.primitive.CharBags;
import org.eclipse.collections.api.factory.primitive.CharLists;
import org.eclipse.collections.api.factory.primitive.CharSets;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.CharList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyCharIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;

public class ReverseCharIterable
extends AbstractLazyCharIterable {
    private final CharList adapted;

    public ReverseCharIterable(CharList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseCharIterable adapt(CharList charList) {
        return new ReverseCharIterable(charList);
    }

    @Override
    public CharIterator charIterator() {
        return new ReverseCharIterator();
    }

    @Override
    public void each(CharProcedure procedure) {
        CharIterator iterator2 = this.charIterator();
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    @Override
    public long sum() {
        return this.adapted.sum();
    }

    @Override
    public char max() {
        return this.adapted.max();
    }

    @Override
    public char min() {
        return this.adapted.min();
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    @Override
    public double average() {
        return this.adapted.average();
    }

    @Override
    public double median() {
        return this.adapted.median();
    }

    @Override
    public char[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    @Override
    public char[] toArray() {
        char[] results = new char[this.adapted.size()];
        int index = 0;
        CharIterator iterator2 = this.charIterator();
        while (iterator2.hasNext()) {
            results[index] = iterator2.next();
            ++index;
        }
        return results;
    }

    @Override
    public boolean contains(char value) {
        return this.adapted.contains(value);
    }

    @Override
    public boolean containsAll(char ... source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public int size() {
        return this.adapted.size();
    }

    @Override
    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    @Override
    public MutableCharList toList() {
        return CharLists.mutable.withAll(this);
    }

    @Override
    public MutableCharSet toSet() {
        return CharSets.mutable.withAll(this);
    }

    @Override
    public MutableCharBag toBag() {
        return CharBags.mutable.withAll(this);
    }

    @Override
    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    private class ReverseCharIterator
    implements CharIterator {
        private int currentIndex;

        private ReverseCharIterator() {
            this.currentIndex = ReverseCharIterable.this.adapted.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        @Override
        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            char next = ReverseCharIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

