/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.NamedArg;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;
import org.fxmisc.flowless.Virtualized;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

@DefaultProperty(value="content")
public class VirtualizedScrollPane<V extends Region>
extends Region
implements Virtualized {
    private static final PseudoClass CONTENT_FOCUSED = PseudoClass.getPseudoClass("content-focused");
    private final ScrollBar hbar;
    private final ScrollBar vbar;
    private final V content;
    private final ChangeListener<Boolean> contentFocusedListener;
    private final ChangeListener<Double> hbarValueListener;
    private ChangeListener<Double> hPosEstimateListener;
    private final ChangeListener<Double> vbarValueListener;
    private final ChangeListener<Double> vPosEstimateListener;
    private Var<Double> hbarValue;
    private Var<Double> vbarValue;
    private Var<Double> hPosEstimate;
    private Var<Double> vPosEstimate;
    private final Var<ScrollPane.ScrollBarPolicy> hbarPolicy;
    private final Var<ScrollPane.ScrollBarPolicy> vbarPolicy;

    public final ScrollPane.ScrollBarPolicy getHbarPolicy() {
        return (ScrollPane.ScrollBarPolicy)((Object)this.hbarPolicy.getValue());
    }

    public final void setHbarPolicy(ScrollPane.ScrollBarPolicy value) {
        this.hbarPolicy.setValue(value);
    }

    public final Var<ScrollPane.ScrollBarPolicy> hbarPolicyProperty() {
        return this.hbarPolicy;
    }

    public final ScrollPane.ScrollBarPolicy getVbarPolicy() {
        return (ScrollPane.ScrollBarPolicy)((Object)this.vbarPolicy.getValue());
    }

    public final void setVbarPolicy(ScrollPane.ScrollBarPolicy value) {
        this.vbarPolicy.setValue(value);
    }

    public final Var<ScrollPane.ScrollBarPolicy> vbarPolicyProperty() {
        return this.vbarPolicy;
    }

    public VirtualizedScrollPane(@NamedArg(value="content") V content, @NamedArg(value="hPolicy") ScrollPane.ScrollBarPolicy hPolicy, @NamedArg(value="vPolicy") ScrollPane.ScrollBarPolicy vPolicy) {
        this.getStyleClass().add("virtualized-scroll-pane");
        this.content = content;
        this.hbar = new ScrollBar();
        this.vbar = new ScrollBar();
        this.hbar.setOrientation(Orientation.HORIZONTAL);
        this.vbar.setOrientation(Orientation.VERTICAL);
        this.hbar.setMin(0.0);
        this.vbar.setMin(0.0);
        this.hbar.maxProperty().bind(((Virtualized)content).totalWidthEstimateProperty());
        this.vbar.maxProperty().bind(((Virtualized)content).totalHeightEstimateProperty());
        VirtualizedScrollPane.setupUnitIncrement(this.hbar);
        VirtualizedScrollPane.setupUnitIncrement(this.vbar);
        this.hbar.blockIncrementProperty().bind(this.hbar.visibleAmountProperty());
        this.vbar.blockIncrementProperty().bind(this.vbar.visibleAmountProperty());
        Val<Double> hContentPadding = Val.map(((Region)content).paddingProperty(), p -> p.getLeft() + p.getRight());
        Val<Double> vContentPadding = Val.map(((Region)content).paddingProperty(), p -> p.getTop() + p.getBottom());
        this.hPosEstimate = Val.combine(((Virtualized)content).estimatedScrollXProperty(), Val.map(((Node)content).layoutBoundsProperty(), Bounds::getWidth), hContentPadding, ((Virtualized)content).totalWidthEstimateProperty(), VirtualizedScrollPane::offsetToScrollbarPosition).asVar(this::setHPosition);
        this.vPosEstimate = Val.combine(((Virtualized)content).estimatedScrollYProperty(), Val.map(((Node)content).layoutBoundsProperty(), Bounds::getHeight), vContentPadding, ((Virtualized)content).totalHeightEstimateProperty(), VirtualizedScrollPane::offsetToScrollbarPosition).orElseConst(0.0).asVar(this::setVPosition);
        this.hbarValue = Var.doubleVar(this.hbar.valueProperty());
        this.vbarValue = Var.doubleVar(this.vbar.valueProperty());
        this.hbarValueListener = (observable2, oldValue, newValue) -> {
            this.hPosEstimate.removeListener(this.hPosEstimateListener);
            this.hPosEstimate.setValue((Double)newValue);
            this.hPosEstimate.addListener(this.hPosEstimateListener);
        };
        this.hbarValue.addListener(this.hbarValueListener);
        this.hPosEstimateListener = (observable2, oldValue, newValue) -> {
            this.hbarValue.removeListener(this.hbarValueListener);
            this.hbarValue.setValue((Double)newValue);
            this.hbarValue.addListener(this.hbarValueListener);
        };
        this.hPosEstimate.addListener(this.hPosEstimateListener);
        this.vbarValueListener = (observable2, oldValue, newValue) -> this.vPosEstimate.setValue((Double)newValue);
        this.vbarValue.addListener(this.vbarValueListener);
        this.vPosEstimateListener = (observable2, oldValue, newValue) -> this.vbarValue.setValue((Double)newValue);
        this.vPosEstimate.addListener(this.vPosEstimateListener);
        this.hbarPolicy = Var.newSimpleVar(hPolicy);
        this.vbarPolicy = Var.newSimpleVar(vPolicy);
        Val<Double> layoutWidth = Val.map(this.layoutBoundsProperty(), Bounds::getWidth);
        Val<Double> layoutHeight = Val.map(this.layoutBoundsProperty(), Bounds::getHeight);
        Val<Boolean> needsHBar0 = Val.combine(((Virtualized)content).totalWidthEstimateProperty(), hContentPadding, layoutWidth, (cw, hcp, lw) -> cw + hcp > lw);
        Val<Boolean> needsVBar0 = Val.combine(((Virtualized)content).totalHeightEstimateProperty(), vContentPadding, layoutHeight, (ch, vcp, lh) -> ch + vcp > lh);
        Val<Boolean> needsHBar = Val.combine(needsHBar0, needsVBar0, ((Virtualized)content).totalWidthEstimateProperty(), hContentPadding, this.vbar.widthProperty(), layoutWidth, (needsH, needsV, cw, hcp, vbw, lw) -> needsH != false || needsV != false && cw + hcp + vbw.doubleValue() > lw);
        Val<Boolean> needsVBar = Val.combine(needsVBar0, needsHBar0, ((Virtualized)content).totalHeightEstimateProperty(), vContentPadding, this.hbar.heightProperty(), layoutHeight, (needsV, needsH, ch, vcp, hbh, lh) -> needsV != false || needsH != false && ch + vcp + hbh.doubleValue() > lh);
        Val shouldDisplayHorizontal = Val.flatMap(this.hbarPolicy, policy -> {
            switch (policy) {
                case NEVER: {
                    return Val.constant(false);
                }
                case ALWAYS: {
                    return Val.constant(true);
                }
            }
            return needsHBar;
        });
        Val shouldDisplayVertical = Val.flatMap(this.vbarPolicy, policy -> {
            switch (policy) {
                case NEVER: {
                    return Val.constant(false);
                }
                case ALWAYS: {
                    return Val.constant(true);
                }
            }
            return needsVBar;
        });
        shouldDisplayHorizontal.addListener(obs -> Platform.runLater(this::requestLayout));
        shouldDisplayVertical.addListener(obs -> Platform.runLater(this::requestLayout));
        this.hbar.visibleProperty().bind(shouldDisplayHorizontal);
        this.vbar.visibleProperty().bind(shouldDisplayVertical);
        this.contentFocusedListener = (obs, ov, nv) -> this.pseudoClassStateChanged(CONTENT_FOCUSED, (boolean)nv);
        ((Node)content).focusedProperty().addListener(this.contentFocusedListener);
        this.getChildren().addAll((Node[])new Node[]{content, this.hbar, this.vbar});
        this.getChildren().addListener(obs -> this.dispose());
    }

    public VirtualizedScrollPane(@NamedArg(value="content") V content) {
        this(content, ScrollPane.ScrollBarPolicy.AS_NEEDED, ScrollPane.ScrollBarPolicy.AS_NEEDED);
    }

    public V getContent() {
        return this.content;
    }

    public V removeContent() {
        this.getChildren().clear();
        return this.content;
    }

    private void dispose() {
        ((Node)this.content).focusedProperty().removeListener(this.contentFocusedListener);
        this.hbarValue.removeListener(this.hbarValueListener);
        this.hPosEstimate.removeListener(this.hPosEstimateListener);
        this.vbarValue.removeListener(this.vbarValueListener);
        this.vPosEstimate.removeListener(this.vPosEstimateListener);
        this.unbindScrollBar(this.hbar);
        this.unbindScrollBar(this.vbar);
    }

    private void unbindScrollBar(ScrollBar bar) {
        bar.maxProperty().unbind();
        bar.unitIncrementProperty().unbind();
        bar.blockIncrementProperty().unbind();
        bar.visibleProperty().unbind();
    }

    @Override
    public Val<Double> totalWidthEstimateProperty() {
        return ((Virtualized)this.content).totalWidthEstimateProperty();
    }

    @Override
    public Val<Double> totalHeightEstimateProperty() {
        return ((Virtualized)this.content).totalHeightEstimateProperty();
    }

    @Override
    public Var<Double> estimatedScrollXProperty() {
        return ((Virtualized)this.content).estimatedScrollXProperty();
    }

    @Override
    public Var<Double> estimatedScrollYProperty() {
        return ((Virtualized)this.content).estimatedScrollYProperty();
    }

    @Override
    public void scrollXBy(double deltaX) {
        ((Virtualized)this.content).scrollXBy(deltaX);
    }

    @Override
    public void scrollYBy(double deltaY) {
        ((Virtualized)this.content).scrollYBy(deltaY);
    }

    @Override
    public void scrollXToPixel(double pixel) {
        ((Virtualized)this.content).scrollXToPixel(pixel);
    }

    @Override
    public void scrollYToPixel(double pixel) {
        ((Virtualized)this.content).scrollYToPixel(pixel);
    }

    @Override
    protected double computePrefWidth(double height) {
        return ((Region)this.content).prefWidth(height);
    }

    @Override
    protected double computePrefHeight(double width) {
        return ((Region)this.content).prefHeight(width);
    }

    @Override
    protected double computeMinWidth(double height) {
        return this.vbar.minWidth(-1.0);
    }

    @Override
    protected double computeMinHeight(double width) {
        return this.hbar.minHeight(-1.0);
    }

    @Override
    protected double computeMaxWidth(double height) {
        return ((Region)this.content).maxWidth(height);
    }

    @Override
    protected double computeMaxHeight(double width) {
        return ((Region)this.content).maxHeight(width);
    }

    @Override
    protected void layoutChildren() {
        double layoutWidth = this.snapSizeX(this.getLayoutBounds().getWidth());
        double layoutHeight = this.snapSizeY(this.getLayoutBounds().getHeight());
        boolean vbarVisible = this.vbar.isVisible();
        boolean hbarVisible = this.hbar.isVisible();
        double vbarWidth = this.snapSizeX(vbarVisible ? this.vbar.prefWidth(-1.0) : 0.0);
        double hbarHeight = this.snapSizeY(hbarVisible ? this.hbar.prefHeight(-1.0) : 0.0);
        double w = layoutWidth - vbarWidth;
        double h = layoutHeight - hbarHeight;
        ((Region)this.content).resize(w, h);
        this.hbar.setVisibleAmount(w);
        this.vbar.setVisibleAmount(h);
        if (vbarVisible) {
            this.vbar.resizeRelocate(layoutWidth - vbarWidth, 0.0, vbarWidth, h);
        }
        if (hbarVisible) {
            this.hbar.resizeRelocate(0.0, layoutHeight - hbarHeight, w, hbarHeight);
        }
    }

    private void setHPosition(double pos) {
        Insets padding = ((Region)this.content).getPadding();
        double offset = VirtualizedScrollPane.scrollbarPositionToOffset(pos, ((Node)this.content).getLayoutBounds().getWidth(), padding.getLeft() + padding.getRight(), (Double)((Virtualized)this.content).totalWidthEstimateProperty().getValue());
        if ((Double)((Virtualized)this.content).estimatedScrollXProperty().getValue() != offset) {
            ((Virtualized)this.content).estimatedScrollXProperty().setValue(offset);
        }
    }

    private void setVPosition(double pos) {
        Insets padding = ((Region)this.content).getPadding();
        double offset = VirtualizedScrollPane.scrollbarPositionToOffset(pos, ((Node)this.content).getLayoutBounds().getHeight(), padding.getTop() + padding.getBottom(), (Double)((Virtualized)this.content).totalHeightEstimateProperty().getValue());
        if ((Double)((Virtualized)this.content).estimatedScrollYProperty().getValue() != offset) {
            ((Virtualized)this.content).estimatedScrollYProperty().setValue(offset);
        }
    }

    private static void setupUnitIncrement(final ScrollBar bar) {
        bar.unitIncrementProperty().bind(new DoubleBinding(){
            {
                this.bind(bar.maxProperty(), bar.visibleAmountProperty());
            }

            @Override
            protected double computeValue() {
                double visible;
                double max = bar.getMax();
                return max > (visible = bar.getVisibleAmount()) ? 16.0 / (max - visible) * max : 0.0;
            }
        });
    }

    private static double offsetToScrollbarPosition(double contentOffset, double viewportSize, double padding, double contentSize) {
        return contentSize > viewportSize ? (double)Math.round(contentOffset / (contentSize - viewportSize + padding) * contentSize) : 0.0;
    }

    private static double scrollbarPositionToOffset(double scrollbarPos, double viewportSize, double padding, double contentSize) {
        return contentSize > viewportSize ? (double)Math.round(scrollbarPos / contentSize * (contentSize - viewportSize + padding)) : 0.0;
    }
}

