/*
 * Decompiled with CFR 0.152.
 */
package tech.energyit.statsd;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import tech.energyit.statsd.Numbers;
import tech.energyit.statsd.Sender;
import tech.energyit.statsd.StatsDClient;
import tech.energyit.statsd.Tag;

public final class FastStatsDClient
implements StatsDClient {
    public static final Charset MESSAGE_CHARSET = StandardCharsets.UTF_8;
    public static final int INITIAL_BUFFER_SIZE = 128;
    public static final int MAX_BUFFER_LENGTH = 0x100000;
    static final double NO_SAMPLE_RATE = 1.0;
    static final char NO_DELTA_SIGN = ' ';
    private static final ThreadLocal<ByteBuffer> MSG_BUFFER = ThreadLocal.withInitial(() -> FastStatsDClient.createByteBuffer(128));
    private final byte[] prefix;
    private final Sender sender;
    private final boolean exactDoubles;

    public FastStatsDClient(Sender sender) {
        this(null, sender);
    }

    public FastStatsDClient(String prefix, Sender sender) {
        this(prefix, sender, false);
    }

    public FastStatsDClient(String prefix, Sender sender, boolean exactDoubles) {
        this.prefix = prefix != null && !prefix.isEmpty() ? (prefix + '.').getBytes(MESSAGE_CHARSET) : new byte[0];
        this.sender = sender;
        this.exactDoubles = exactDoubles;
    }

    @Override
    public void count(byte[] aspect, long delta, Tag ... tags) {
        this.send(aspect, ' ', delta, MetricType.COUNTER, 1.0, tags);
    }

    @Override
    public void count(byte[] aspect, long delta, double sampleRate, Tag ... tags) {
        if (FastStatsDClient.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(aspect, ' ', delta, MetricType.COUNTER, sampleRate, tags);
    }

    @Override
    public void count(byte[] aspect, double delta, Tag ... tags) {
        this.send(aspect, ' ', delta, MetricType.COUNTER, 1.0, tags);
    }

    @Override
    public void count(byte[] aspect, double delta, double sampleRate, Tag ... tags) {
        if (FastStatsDClient.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(aspect, ' ', delta, MetricType.COUNTER, sampleRate, tags);
    }

    @Override
    public void gauge(byte[] aspect, long value, Tag ... tags) {
        this.send(aspect, ' ', value, MetricType.GAUGE, 1.0, tags);
    }

    @Override
    public void gauge(byte[] aspect, char deltaSign, long value, Tag ... tags) {
        this.send(aspect, deltaSign, value, MetricType.GAUGE, 1.0, tags);
    }

    @Override
    public void gauge(byte[] aspect, long value, double sampleRate, Tag ... tags) {
        if (FastStatsDClient.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(aspect, ' ', value, MetricType.GAUGE, sampleRate, tags);
    }

    @Override
    public void gauge(byte[] aspect, double value, Tag ... tags) {
        this.send(aspect, ' ', value, MetricType.GAUGE, 1.0, tags);
    }

    @Override
    public void gauge(byte[] aspect, char deltaSign, double value, Tag ... tags) {
        this.send(aspect, deltaSign, value, MetricType.GAUGE, 1.0, tags);
    }

    @Override
    public void gauge(byte[] aspect, double value, double sampleRate, Tag ... tags) {
        if (FastStatsDClient.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(aspect, ' ', value, MetricType.GAUGE, sampleRate, tags);
    }

    @Override
    public void time(byte[] aspect, long timeInMs, Tag ... tags) {
        this.send(aspect, ' ', timeInMs, MetricType.TIMER, 1.0, tags);
    }

    @Override
    public void time(byte[] aspect, long timeInMs, double sampleRate, Tag ... tags) {
        if (FastStatsDClient.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(aspect, ' ', timeInMs, MetricType.TIMER, sampleRate, tags);
    }

    @Override
    public void histogram(byte[] aspect, long value, Tag ... tags) {
        this.send(aspect, ' ', value, MetricType.HISTOGRAM, 1.0, tags);
    }

    @Override
    public void histogram(byte[] aspect, long value, double sampleRate, Tag ... tags) {
        if (FastStatsDClient.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(aspect, ' ', value, MetricType.HISTOGRAM, sampleRate, tags);
    }

    @Override
    public void histogram(byte[] aspect, double value, Tag ... tags) {
        this.send(aspect, ' ', value, MetricType.HISTOGRAM, 1.0, tags);
    }

    @Override
    public void histogram(byte[] aspect, double value, double sampleRate, Tag ... tags) {
        if (FastStatsDClient.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(aspect, ' ', value, MetricType.HISTOGRAM, sampleRate, tags);
    }

    @Override
    public void set(byte[] aspect, long value, Tag ... tags) {
        this.send(aspect, ' ', value, MetricType.SET, 1.0, tags);
    }

    @Override
    public void set(byte[] aspect, long value, double sampleRate, Tag ... tags) {
        if (FastStatsDClient.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(aspect, ' ', value, MetricType.SET, sampleRate, tags);
    }

    @Override
    public void set(byte[] aspect, double value, Tag ... tags) {
        this.send(aspect, ' ', value, MetricType.SET, 1.0, tags);
    }

    @Override
    public void set(byte[] aspect, double value, double sampleRate, Tag ... tags) {
        if (FastStatsDClient.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(aspect, ' ', value, MetricType.SET, sampleRate, tags);
    }

    @Override
    public void meter(byte[] aspect, long value, Tag ... tags) {
        this.send(aspect, ' ', value, MetricType.METER, 1.0, tags);
    }

    @Override
    public void meter(byte[] aspect, double value, Tag ... tags) {
        this.send(aspect, ' ', value, MetricType.METER, 1.0, tags);
    }

    public void clear() {
        MSG_BUFFER.remove();
    }

    private void send(byte[] metricName, char deltaSign, long value, MetricType metricType, double sampleRate, Tag[] tags) {
        ByteBuffer buffer = MSG_BUFFER.get();
        boolean formatted = false;
        while (!formatted) {
            try {
                buffer.clear();
                this.putPrefix(metricName, buffer, deltaSign);
                FastStatsDClient.putLong(buffer, value);
                this.putSuffix(buffer, metricType, sampleRate, tags);
                buffer.flip();
                formatted = true;
            }
            catch (BufferOverflowException e) {
                buffer = FastStatsDClient.createByteBuffer(FastStatsDClient.newCapacity(buffer.capacity()));
                MSG_BUFFER.set(buffer);
            }
        }
        this.sender.send(buffer);
    }

    private void send(byte[] metricName, char deltaSign, double value, MetricType metricType, double sampleRate, Tag[] tags) {
        ByteBuffer buffer = MSG_BUFFER.get();
        boolean formatted = false;
        while (!formatted) {
            try {
                buffer.clear();
                this.putPrefix(metricName, buffer, deltaSign);
                FastStatsDClient.putDouble(buffer, value, this.exactDoubles);
                this.putSuffix(buffer, metricType, sampleRate, tags);
                buffer.flip();
                formatted = true;
            }
            catch (BufferOverflowException e) {
                buffer = FastStatsDClient.createByteBuffer(FastStatsDClient.newCapacity(buffer.capacity()));
                MSG_BUFFER.set(buffer);
            }
        }
        this.sender.send(buffer);
    }

    private void putPrefix(byte[] metricName, ByteBuffer buffer, char deltaSign) {
        buffer.put(this.prefix);
        buffer.put(metricName);
        buffer.put((byte)58);
        if (deltaSign != ' ') {
            buffer.put((byte)deltaSign);
        }
    }

    private void putSuffix(ByteBuffer buffer, MetricType metricType, double sampleRate, Tag[] tags) {
        buffer.put((byte)124);
        buffer.put(metricType.key);
        if (sampleRate != 1.0) {
            buffer.put((byte)124);
            buffer.put((byte)64);
            FastStatsDClient.putDouble(buffer, sampleRate, this.exactDoubles);
        }
        if (tags != null && tags.length > 0) {
            buffer.put((byte)124);
            buffer.put((byte)35);
            for (int i = 0; i < tags.length; ++i) {
                Tag tag = tags[i];
                buffer.put(tag.getName());
                buffer.put((byte)58);
                buffer.put(tag.getValue());
                if (i >= tags.length - 1) continue;
                buffer.put((byte)44);
            }
        }
    }

    private static int newCapacity(int currentCapacity) {
        if (currentCapacity >= 0x100000) {
            throw new IllegalArgumentException("Message too big. This is maximum : 1048576");
        }
        long value = 2L * (long)currentCapacity;
        if (value >= 0x100000L) {
            value = 0x100000L;
        }
        return (int)value;
    }

    private static void putLong(ByteBuffer bb, long v) {
        Numbers.putLongAsAsciiBytes(v, bb);
    }

    private static void putDouble(ByteBuffer bb, double v, boolean exactDoubles) {
        Numbers.putDoubleAsAsciiBytes(v, bb, MESSAGE_CHARSET, exactDoubles);
    }

    private static boolean isInvalidSample(double sampleRate) {
        return sampleRate <= 0.0 || sampleRate > 1.0;
    }

    private static ByteBuffer createByteBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity);
    }

    static enum MetricType {
        GAUGE("g"),
        TIMER("ms"),
        COUNTER("c"),
        HISTOGRAM("h"),
        SET("s"),
        METER("m");

        private final byte[] key;

        private MetricType(String key) {
            this.key = key.getBytes(MESSAGE_CHARSET);
        }
    }
}

