/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.ComXervLoadContext;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadSingleEntityTypeTask;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.entities.OrderLimit;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class LoadOrderLimitsTask
extends LoadSingleEntityTypeTask<OrderLimit> {
    public LoadOrderLimitsTask(ComXervLoadContext loadContext) {
        super(loadContext, OrderLimit.class);
    }

    @Override
    protected Set<OrderLimit> load() {
        HashSet<OrderLimit> result = new HashSet<OrderLimit>();
        UserRoles userRoles = this.getLoadContext().getUserRoles();
        boolean hasProperRole = userRoles.isAdmin() || userRoles.isTrader() || userRoles.isBroker();
        AbstractComXervExchangeConnection connection = this.getLoadContext().getConnection();
        if (connection != null && hasProperRole && this.getLoadContext().getExchange().getSystemInfo().supportsTradingLimit()) {
            Set<String> productIds = this.getLoadContext().getAll(Product.class).map(BroadcastEntity::getId).collect(Collectors.toSet());
            result.addAll(connection.getOrderLimits(productIds));
        }
        return result;
    }

    @Override
    public boolean runCondition() {
        return this.getLoadContext().getExchange().getSystemInfo().supportsTradingLimit();
    }
}

