/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.AbstractComXervService;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.ExchangeSpecific;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeState;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeSubmitter;
import com.deutscheboerse.m7.trading.api.Request;
import com.deutscheboerse.m7.trading.api.v6.ErrResp;
import com.deutscheboerse.m7.trading.api.v6.TradeCancelProcess;
import com.deutscheboerse.m7.trading.api.v6.TradeProcessResp;
import com.deutscheboerse.m7.trading.api.v6.TradeRecallProcess;
import com.deutscheboerse.m7.trading.api.v6.TradeRecallReq;
import com.deutscheboerse.m7.trading.api.v6.TrdProcessType;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ExchangeSpecific(apiVersion="v6")
public class ComXervTradeSubmitter
extends AbstractComXervService
implements TradeSubmitter {
    private static final Logger LOG = LoggerFactory.getLogger(ComXervTradeSubmitter.class);

    @Inject
    public ComXervTradeSubmitter(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public Request createTradeRequest(Trade trade, TradeState tradeState, boolean recallCapacity, boolean ignoreNegativeLimit) {
        if (TradeState.CANCELLED.equals(tradeState) || TradeState.CANCEL_REQUESTED.equals(trade.getTradeState())) {
            TradeCancelProcess tradeCancelProcess = new TradeCancelProcess();
            tradeCancelProcess.setStandardHeader(this.getStandardHeader(false));
            tradeCancelProcess.setTradeId(trade.getTradeId());
            tradeCancelProcess.setState(EnumMapper.mapTradeState(tradeState));
            tradeCancelProcess.setRecallCapacity(recallCapacity);
            tradeCancelProcess.setRevisionNo(trade.getRevisionNumber());
            tradeCancelProcess.setIgnoreNegativeLimit(ignoreNegativeLimit);
            return tradeCancelProcess;
        }
        if (TradeState.RECALL_REQUESTED.equals(tradeState)) {
            TradeRecallReq tradeRecallReq = new TradeRecallReq();
            tradeRecallReq.setStandardHeader(this.getStandardHeader(true));
            tradeRecallReq.setTradeId(trade.getTradeId());
            tradeRecallReq.setRevisionNo(trade.getRevisionNumber());
            return tradeRecallReq;
        }
        TradeRecallProcess tradeRecallProcess = new TradeRecallProcess();
        tradeRecallProcess.setStandardHeader(this.getStandardHeader(false));
        tradeRecallProcess.setTradeId(trade.getTradeId());
        tradeRecallProcess.setState(EnumMapper.mapTradeState(tradeState));
        tradeRecallProcess.setRecallCapacity(recallCapacity);
        tradeRecallProcess.setRevisionNo(trade.getRevisionNumber());
        tradeRecallProcess.setIgnoreNegativeLimit(ignoreNegativeLimit);
        return tradeRecallProcess;
    }

    @Override
    public boolean processAsyncServerResponse(Object response, ResponseHandler responseHandler) {
        if (response instanceof ErrResp) {
            ErrResp errResp = (ErrResp)response;
            this.handleErrors(errResp.getError().stream(), responseHandler);
            return true;
        }
        if (response instanceof TradeProcessResp) {
            TradeProcessResp tradeProcessResp = (TradeProcessResp)response;
            if (this.getConnection() != null) {
                TrdProcessType type = tradeProcessResp.getTradeProcessType();
                try {
                    AsyncResponse asyncResponse = this.getMapper().translate(AsyncResponse.class, type);
                    responseHandler.handleResponse(asyncResponse);
                }
                catch (RuntimeException e) {
                    LOG.error("Error handling response", e);
                    responseHandler.handleGeneralError();
                }
            }
            return true;
        }
        return false;
    }
}

