/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.ComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.ExchangeSpecific;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.AcceptOrRejectType;
import com.deutscheboerse.comxerv.comtrader.entities.type.BasketRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.module.SenderExecutor;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.amqp.CorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ResponseWithCorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandlerWithTimeout;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandlerWithTimeoutFactory;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSender;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSubmitter;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrdersToSend;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OtcOrderService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.SentOrders;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.ExchangeSpecificServiceLookup;
import com.deutscheboerse.m7.trading.api.Request;
import com.deutscheboerse.m7.trading.api.v6.PreArrangedOrdrProcess;
import com.deutscheboerse.m7.trading.api.v6.StandardHeaderType;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ExchangeSpecific(apiVersion="v6")
public class OtcOrderServiceImpl
implements OtcOrderService {
    private static final Logger LOG = LoggerFactory.getLogger(OtcOrderServiceImpl.class);
    private final BackendConnectionGateway backendConnectionGateway;
    private final OnBehalfService onBehalfService;
    private final UserService userService;
    private final OrderSender orderSender;
    private final ExchangeSpecificServiceLookup serviceLookup;
    private final ResponseHandlerWithTimeoutFactory responseHandlerWithTimeoutFactory;
    private final ExecutorService executorService;
    private final MessagePublisher messagePublisher;
    private final DataModel<Long, Order> orderDataModel;

    @Inject
    public OtcOrderServiceImpl(ApplicationContext applicationContext) {
        this.backendConnectionGateway = applicationContext.getService(BackendConnectionGateway.class);
        this.onBehalfService = applicationContext.getService(OnBehalfService.class);
        this.userService = applicationContext.getService(UserService.class);
        this.orderSender = applicationContext.getService(OrderSender.class);
        this.serviceLookup = applicationContext.getService(ExchangeSpecificServiceLookup.class);
        this.responseHandlerWithTimeoutFactory = applicationContext.getService(ResponseHandlerWithTimeoutFactory.class);
        this.messagePublisher = applicationContext.getService(MessagePublisher.class);
        this.executorService = applicationContext.getService(ExecutorService.class, SenderExecutor.class);
        this.orderDataModel = applicationContext.getDataModel(Order.class);
    }

    @Override
    public void acceptOtcOrder(Order order, ResponseHandler responseHandler) {
        order.setPreArrangedAcceptOrReject(AcceptOrRejectType.ACCEPT);
        this.sendPreArrangedOrderProcess(order, response -> {
            this.messagePublisher.publishMessage(response);
            if (responseHandler != null) {
                responseHandler.handleResponse(response);
            }
        });
    }

    @Override
    public void rejectOtcOrder(Order order) {
        order.setPreArrangedAcceptOrReject(AcceptOrRejectType.REJECT);
        this.sendPreArrangedOrderProcess(order, this.messagePublisher::publishMessage);
    }

    private void sendPreArrangedOrderProcess(Order order, ResponseHandler responseHandler) {
        if (order.getContract().getProduct().isOtcTradingSupported()) {
            ComXervExchangeConnection connection = (ComXervExchangeConnection)this.backendConnectionGateway.getConnection();
            if (connection != null) {
                this.executorService.submit(() -> {
                    try {
                        PreArrangedOrdrProcess request = new PreArrangedOrdrProcess();
                        StandardHeaderType standardHeader = connection.createStandardHeader();
                        standardHeader.setOnBehalfUserId(this.onBehalfService.getOnBehalfUserId());
                        request.setStandardHeader(standardHeader);
                        request.setAction(EnumMapper.mapAcceptOrRejectType(order.getPreArrangedAcceptOrReject()));
                        request.setClearingAcctType(order.getAccount());
                        request.setOrdrId((Long)order.getId());
                        request.setTxt(order.getText());
                        request.setDlvryAreaId(order.getDeliveryArea() != null ? (String)order.getDeliveryArea().getId() : null);
                        request.setRevisionNo(order.getRevisionNumber());
                        OrderSubmitter submitter = this.serviceLookup.getExchangeSpecificService(OrderSubmitter.class, order.getExchange());
                        String correlationId = CorrelationId.next();
                        ResponseHandlerWithTimeout responseHandlerWithTimeout = this.responseHandlerWithTimeoutFactory.createHandler(responseHandler, correlationId);
                        SentOrders sentOrders = new SentOrders(responseHandlerWithTimeout, order.getExchange(), BasketRestriction.NONE, Collections.emptyMap(), correlationId);
                        ObjectHandler objectHandler = this.getObjectHandler(submitter, sentOrders);
                        connection.addObjectHandler(objectHandler);
                        responseHandlerWithTimeout.startTimeout(() -> connection.removeObjectHandler(objectHandler));
                        ResponseWithCorrelationId responseWithCorrelationId = connection.sendRequest((Request)request, false, correlationId);
                        this.processServerResponse(responseWithCorrelationId, responseHandlerWithTimeout, submitter, connection, objectHandler);
                    }
                    catch (RuntimeException e) {
                        LOG.error("Error when submitting PreArrangedOrdrProcess.", e);
                        responseHandler.handleResponse(new AsyncResponse(ResponseStatus.ERROR, null));
                    }
                });
            }
        } else {
            LOG.error("OTC orders are not supported for {}", (Object)order.getExchange().getDisplayName());
        }
    }

    private void processServerResponse(ResponseWithCorrelationId response, ResponseHandler responseHandler, OrderSubmitter submitter, ExchangeConnection connection, ObjectHandler objectHandler) {
        boolean expectOtherMessages;
        if (response.getResponse() != null && !(expectOtherMessages = submitter.processImmediateServerResponse(response.getResponse(), responseHandler))) {
            connection.removeObjectHandler(objectHandler);
        }
    }

    private ObjectHandler getObjectHandler(OrderSubmitter submitter, SentOrders sentOrders) {
        return (session, broadcastObject, correlationId) -> {
            if (sentOrders.getCorrelationId().equals(correlationId)) {
                return submitter.processAsyncServerResponse(broadcastObject, sentOrders) ? ObjectHandler.Result.RETAIN : ObjectHandler.Result.REMOVE;
            }
            return ObjectHandler.Result.RETAIN;
        };
    }

    @Override
    public void modifyOtcOrder(List<Order> orders, RequestType requestType) {
        ArrayList<Order> ordersToSend = new ArrayList<Order>();
        for (Order order : orders) {
            if (requestType == RequestType.DELETE && order.getStatus() == OrderStatus.ERROR) {
                this.orderDataModel.remove(order);
                continue;
            }
            ordersToSend.add(order);
        }
        if (!ordersToSend.isEmpty()) {
            this.orderSender.sendOrder(new OrdersToSend(ordersToSend, requestType, ResponseHandler.EMPTY));
        }
    }

    @Override
    public boolean isOtcOrderModifiable(Order order) {
        return (order.getStatus() == OrderStatus.ACTIVE || order.getStatus() == OrderStatus.HIBERNATE) && this.isMemberOfBG(order.getBalancingGroup());
    }

    @Override
    public boolean isOtcOrderRejectable(Order order) {
        return order.getStatus() == OrderStatus.ACTIVE && this.isMemberOfBG(order.getPreArrangedBalancingGroup());
    }

    @Override
    public boolean isOtcOrderAcceptable(Order order) {
        return order.getStatus() == OrderStatus.ACTIVE && this.isMemberOfBG(order.getPreArrangedBalancingGroup());
    }

    private boolean isOtcOrderCancellable(Order order) {
        return order.getStatus() == OrderStatus.ERROR || this.isOtcOrderModifiable(order);
    }

    @Override
    public boolean isOtcOrderCancellable(List<Order> orders) {
        return orders.stream().allMatch(this::isOtcOrderCancellable);
    }

    private boolean isMemberOfBG(BalancingGroup balancingGroup) {
        return this.userService.getCurrentUser().containsBalancingGroupId((String)balancingGroup.getId());
    }
}

