/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.listener.MapperAndContextAwareNotifyListenersObjectHandler;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.m7.trading.api.v6.RefPxRprt;
import java.util.Collection;
import java.util.Collections;
import org.joda.time.DateTime;

public class RefPxRprtNotifyListenersObjectHandler
extends MapperAndContextAwareNotifyListenersObjectHandler<RefPxRprt> {
    public RefPxRprtNotifyListenersObjectHandler(BroadcastListenerHandlerForClass broadcastHandler, ApplicationContext appContext, MapperHandler mappers) {
        super(broadcastHandler, appContext, mappers);
    }

    @Override
    public Collection<Orderbook> unpack(RefPxRprt refPxRprt, Exchange exchange, String correlationId) {
        if (refPxRprt.getRefPxList() != null && refPxRprt.getRefPxList().getRefPx() != null) {
            TimeService timeService = this.appContext.getService(TimeService.class);
            DateTime exchangeDateTime = timeService.getServerTime();
            DateTime tomorrowStartOfDay = exchangeDateTime.plusDays(1).withTimeAtStartOfDay();
            DateTime yesterdayStartOfDay = exchangeDateTime.minusDays(1).withTimeAtStartOfDay();
            return this.mappers.translateList(Orderbook.class, refPxRprt.getRefPxList().getRefPx().stream().filter(refPx -> {
                DateTime closingPriceDateTime = DateTimeUtils.mapDateToDateTime(refPx.getDate(), exchange.getSystemInfo().getTimeZone());
                return closingPriceDateTime.isBefore(tomorrowStartOfDay) && closingPriceDateTime.compareTo(yesterdayStartOfDay) >= 0;
            }).toList());
        }
        return Collections.emptyList();
    }
}

