/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.entities.session.DisconnectAction;
import com.deutscheboerse.comxerv.comtrader.entities.type.AcceptOrRejectType;
import com.deutscheboerse.comxerv.comtrader.entities.type.AggressorIndicatorType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractPhase;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ModificationType;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.PutOrCall;
import com.deutscheboerse.comxerv.comtrader.entities.type.SuspensionType;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeState;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.m7.trading.api.v6.CallPutContractType;
import com.deutscheboerse.m7.trading.api.v6.ContractPhaseType;
import com.deutscheboerse.m7.trading.api.v6.ContractStateType;
import com.deutscheboerse.m7.trading.api.v6.DirectionType;
import com.deutscheboerse.m7.trading.api.v6.DisconnectActType;
import com.deutscheboerse.m7.trading.api.v6.MemberType;
import com.deutscheboerse.m7.trading.api.v6.OpenCloseIndType;
import com.deutscheboerse.m7.trading.api.v6.OrderStateType;
import com.deutscheboerse.m7.trading.api.v6.OrdrExeRestrictionType;
import com.deutscheboerse.m7.trading.api.v6.OrdrModAllType;
import com.deutscheboerse.m7.trading.api.v6.OrdrModType;
import com.deutscheboerse.m7.trading.api.v6.OrdrType;
import com.deutscheboerse.m7.trading.api.v6.OriginatorAggressorType;
import com.deutscheboerse.m7.trading.api.v6.PreArrAccRejType;
import com.deutscheboerse.m7.trading.api.v6.RefDataDeliveryAreaStateType;
import com.deutscheboerse.m7.trading.api.v6.RefDataStateType;
import com.deutscheboerse.m7.trading.api.v6.TradeStateType;
import com.deutscheboerse.m7.trading.api.v6.ValidityRestrictionType;

public class EnumMapper {
    public static Direction mapDirection(DirectionType direction) {
        switch (direction) {
            case BUY: {
                return Direction.BUY;
            }
            case SELL: {
                return Direction.SELL;
            }
        }
        throw new IllegalArgumentException("Invalid DirectionType \"" + String.valueOf(direction) + "\"");
    }

    public static DirectionType mapDirection(Direction direction) {
        switch (direction) {
            case BUY: {
                return DirectionType.BUY;
            }
            case SELL: {
                return DirectionType.SELL;
            }
        }
        throw new IllegalStateException("Invalid Direction: " + String.valueOf(direction));
    }

    public static TradeState mapTradeState(TradeStateType type) {
        switch (type) {
            case ACTI: {
                return TradeState.ACTIVE;
            }
            case CNCL: {
                return TradeState.CANCELLED;
            }
            case RGRA: {
                return TradeState.RECALL_GRANTED;
            }
            case RREJ: {
                return TradeState.RECALL_REJECTED;
            }
            case RREQ: 
            case RSFA: {
                return TradeState.RECALL_REQUESTED;
            }
            case CREJ: {
                return TradeState.CANCEL_REJECTED;
            }
            case CREQ: {
                return TradeState.CANCEL_REQUESTED;
            }
        }
        throw new IllegalArgumentException("Invalid TradeStateType: " + String.valueOf(type));
    }

    public static PreArrAccRejType mapAcceptOrRejectType(AcceptOrRejectType type) {
        switch (type) {
            case ACCEPT: {
                return PreArrAccRejType.ACC;
            }
            case REJECT: {
                return PreArrAccRejType.REJ;
            }
        }
        throw new IllegalStateException("Invalid AcceptOrRejectType: " + String.valueOf((Object)type));
    }

    public static OrdrModType mapRequestType(RequestType type) {
        switch (type) {
            case ACTIVATE: {
                return OrdrModType.ACTI;
            }
            case DEACTIVATE: {
                return OrdrModType.DEAC;
            }
            case MODIFY: {
                return OrdrModType.MODI;
            }
            case DELETE: {
                return OrdrModType.DELE;
            }
        }
        throw new IllegalStateException("Invalid RequestType: " + String.valueOf((Object)type));
    }

    public static OrdrModAllType mapBatchRequestType(RequestType type) {
        switch (type) {
            case ACTIVATE: {
                return OrdrModAllType.ACTI;
            }
            case DEACTIVATE: {
                return OrdrModAllType.DEAC;
            }
            case DELETE: {
                return OrdrModAllType.DELE;
            }
        }
        throw new IllegalStateException("Invalid RequestType for batch operation: " + String.valueOf((Object)type));
    }

    public static ModificationType mapAction(String action) {
        switch (action) {
            case "UADD": {
                return ModificationType.USER_ADD;
            }
            case "QADD": {
                return ModificationType.QUOTE_ADD;
            }
            case "SADD": {
                return ModificationType.SYSTEM_ADD;
            }
            case "AADD": {
                return ModificationType.ADMIN_ADD;
            }
            case "UMOD": {
                return ModificationType.USER_MODIFICATION;
            }
            case "SMOD": {
                return ModificationType.SYSTEM_MODIFICATION;
            }
            case "AMOD": {
                return ModificationType.ADMIN_MODIFICATION;
            }
            case "UACT": {
                return ModificationType.USER_ACTIVATE;
            }
            case "SACT": {
                return ModificationType.SYSTEM_ACTIVATE;
            }
            case "AACT": {
                return ModificationType.ADMIN_ACTIVATE;
            }
            case "UDEL": {
                return ModificationType.USER_DELETE;
            }
            case "SDEL": {
                return ModificationType.SYSTEM_DELETE;
            }
            case "ADEL": {
                return ModificationType.ADMIN_DELETE;
            }
            case "HIBE": {
                return ModificationType.HIBERNATE;
            }
            case "UHIB": {
                return ModificationType.USER_HIBERNATE;
            }
            case "SHIB": {
                return ModificationType.SYSTEM_HIBERNATE;
            }
            case "AHIB": {
                return ModificationType.ADMIN_HIBERNATE;
            }
            case "FEXE": {
                return ModificationType.ORDER_FULLY_EXECUTED;
            }
            case "QFEX": {
                return ModificationType.QUOTE_FULLY_EXECUTED;
            }
            case "PEXE": {
                return ModificationType.ORDER_PARTIALLY_EXECUTED;
            }
            case "QPEX": {
                return ModificationType.QUOTE_PARTIALLY_EXECUTED;
            }
            case "IADD": {
                return ModificationType.ICEBERG_ADD;
            }
            case "UREJ": {
                return ModificationType.USER_REJECT;
            }
            case "AREJ": {
                return ModificationType.ADMIN_REJECT;
            }
            case "SREJ": {
                return ModificationType.SYSTEM_REJECT;
            }
            case "SNAV": {
                return ModificationType.SOB_NOT_AVAILABLE;
            }
            case "SERR": {
                return ModificationType.SOB_ERROR;
            }
        }
        throw new IllegalStateException("Invalid ModificationType " + action);
    }

    public static TradeStateType mapTradeState(TradeState state) {
        switch (state) {
            case ACTIVE: {
                return TradeStateType.ACTI;
            }
            case RECALL_GRANTED: {
                return TradeStateType.RGRA;
            }
            case RECALL_REJECTED: {
                return TradeStateType.RREJ;
            }
            case RECALL_REQUESTED: {
                return TradeStateType.RREQ;
            }
            case CANCELLED: {
                return TradeStateType.CNCL;
            }
            case CANCEL_REJECTED: {
                return TradeStateType.CREJ;
            }
            case CANCEL_REQUESTED: {
                return TradeStateType.CREQ;
            }
        }
        throw new IllegalStateException("Invalid TradeState: " + String.valueOf(state));
    }

    public static SuspensionType mapSuspensionDeliveryAreaType(RefDataDeliveryAreaStateType type) {
        switch (type) {
            case SUSP: {
                return SuspensionType.SUSPEND;
            }
            case ACTI: {
                return SuspensionType.ACTIVE;
            }
            case DELE: {
                return SuspensionType.DELETE;
            }
        }
        throw new IllegalArgumentException("Invalid RefDataDeliveryAreaStateType: " + String.valueOf(type));
    }

    public static SuspensionType mapSuspensionType(RefDataStateType type) {
        switch (type) {
            case SUSP: {
                return SuspensionType.SUSPEND;
            }
            case IACT: {
                return SuspensionType.INACTIVE;
            }
            case ACTI: {
                return SuspensionType.ACTIVE;
            }
            case DELE: {
                return SuspensionType.DELETE;
            }
        }
        throw new IllegalArgumentException("Invalid RefDataStateType: " + String.valueOf(type));
    }

    public static ContractPhase mapContractPhase(ContractPhaseType contractPhase) {
        switch (contractPhase) {
            case CONT: {
                return ContractPhase.CONT;
            }
            case BALA: {
                return ContractPhase.BALA;
            }
            case AUCT: {
                return ContractPhase.AUCT;
            }
            case CLSD: {
                return ContractPhase.CLSD;
            }
            case SDAT: {
                return ContractPhase.SDAT;
            }
        }
        throw new IllegalArgumentException("Invalid ContractPhaseType: " + String.valueOf(contractPhase));
    }

    public static ContractStatus mapContractStatus(ContractStateType contractState) {
        switch (contractState) {
            case ACTI: {
                return ContractStatus.ACTI;
            }
            case HIBE: {
                return ContractStatus.HIBE;
            }
            case STBY: {
                return ContractStatus.STBY;
            }
            case IACT: {
                return ContractStatus.IACT;
            }
        }
        throw new IllegalArgumentException("Invalid ContractStateType: " + String.valueOf(contractState));
    }

    public static CallPutContractType mapPutOrCall(PutOrCall putOrCall) {
        switch (putOrCall) {
            case PUT: {
                return CallPutContractType.P;
            }
            case CALL: {
                return CallPutContractType.C;
            }
        }
        throw new IllegalArgumentException("Invalid PutOrCall: " + String.valueOf((Object)putOrCall));
    }

    public static com.deutscheboerse.comxerv.comtrader.entities.MemberType mapMemberTypefrom(MemberType type) {
        switch (type) {
            case REG: {
                return com.deutscheboerse.comxerv.comtrader.entities.MemberType.REG;
            }
            case BRK: {
                return com.deutscheboerse.comxerv.comtrader.entities.MemberType.BRK;
            }
        }
        throw new IllegalArgumentException("Invalid MemberType: " + String.valueOf(type));
    }

    public static OpenCloseIndType mapOpenOrClose(OpenOrClose ooc) {
        switch (ooc) {
            case CLOSE: {
                return OpenCloseIndType.C;
            }
            case OPEN: {
                return OpenCloseIndType.O;
            }
        }
        throw new IllegalArgumentException("Invalid OpenOrClose: " + String.valueOf(ooc));
    }

    public static OrderStatus mapOrderStateType(OrderStateType state) {
        switch (state) {
            case ACTI: {
                return OrderStatus.ACTIVE;
            }
            case IACT: {
                return OrderStatus.INACTIVE;
            }
            case HIBE: {
                return OrderStatus.HIBERNATE;
            }
            case UKNW: {
                return OrderStatus.UNKNOWN;
            }
        }
        return null;
    }

    public static ExecutionRestriction mapOrdrExeRestrictionType(OrdrExeRestrictionType ordrRestrictionType) {
        switch (ordrRestrictionType) {
            case AON: {
                return ExecutionRestriction.ALL_OR_NOTHING;
            }
            case FOK: {
                return ExecutionRestriction.FILL_OR_KILL;
            }
            case IOC: {
                return ExecutionRestriction.IMMEDIATE_OR_CANCEL;
            }
            case NON: {
                return ExecutionRestriction.NONE;
            }
        }
        throw new IllegalArgumentException("Invalid ExecutionRestriction \"" + String.valueOf(ordrRestrictionType) + "\"");
    }

    public static OrderType mapOrdrType(OrdrType source, boolean isPreArranged) {
        switch (source) {
            case L: {
                return OrderType.BALANCE;
            }
            case I: {
                return OrderType.ICEBERG;
            }
            case O: 
            case B: {
                return isPreArranged ? OrderType.OTC_PREARRANGED : OrderType.REGULAR;
            }
            case S: {
                return OrderType.STOP;
            }
            case N: {
                return OrderType.CONFIDENTIAL;
            }
            case E: {
                return OrderType.BESPOKE_PREARRANGED;
            }
        }
        throw new IllegalStateException("Invalid order type: " + String.valueOf(source));
    }

    public static ValidityRestriction mapValidityRestrictionType(ValidityRestrictionType validityRestrictionType) {
        switch (validityRestrictionType) {
            case GFS: {
                return ValidityRestriction.GOOD_FOR_SESSION;
            }
            case GTD: {
                return ValidityRestriction.GOOD_TILL_DATE;
            }
            case NON: {
                return ValidityRestriction.NONE;
            }
        }
        throw new IllegalArgumentException("Invalid ValidityRestriction \"" + String.valueOf(validityRestrictionType) + "\"");
    }

    public static OpenOrClose mapOpenCloseIndType(OpenCloseIndType openOrClose) {
        if (openOrClose == null) {
            return null;
        }
        switch (openOrClose) {
            case C: {
                return OpenOrClose.CLOSE;
            }
            case O: {
                return OpenOrClose.OPEN;
            }
        }
        throw new IllegalStateException("Invalid open/close indicator. " + String.valueOf(openOrClose));
    }

    public static AggressorIndicatorType mapAggressorIndicatorType(OriginatorAggressorType aggressorIndicatorType) {
        if (aggressorIndicatorType == null) {
            return AggressorIndicatorType.U;
        }
        switch (aggressorIndicatorType) {
            case Y: {
                return AggressorIndicatorType.Y;
            }
            case N: {
                return AggressorIndicatorType.N;
            }
            case U: {
                return AggressorIndicatorType.U;
            }
        }
        throw new IllegalStateException("Invalid aggressor indicator. " + String.valueOf((Object)aggressorIndicatorType));
    }

    public static DisconnectActType mapDisconnectAction(DisconnectAction disconnectAction) {
        switch (disconnectAction) {
            case NO: {
                return DisconnectActType.NO;
            }
            case DEACT_ACCT_ORDRS: {
                return DisconnectActType.DEACT_ACCT_ORDRS;
            }
            case DEACT_USER_ORDRS: {
                return DisconnectActType.DEACT_USER_ORDRS;
            }
        }
        throw new IllegalStateException("Invalid disconnect action " + String.valueOf(disconnectAction));
    }
}

