/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.app;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.DataModelFactory;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.LargePersistableDataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.core.entity.LargeDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.SmallDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutCleanUpDataModelEvent;
import com.deutscheboerse.comxerv.comtrader.util.ExchangeSpecificServiceLookup;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApplicationContextImpl
implements ApplicationContext {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationContextImpl.class);
    private final Map<Class<? extends BroadcastEntity>, DataModel> dataModels = Collections.synchronizedMap(new HashMap());
    private final Injector injector;

    @Inject
    public ApplicationContextImpl(Injector injector) {
        this.injector = injector;
    }

    public <T> T getService(Class<T> serviceClass, Exchange exchange) {
        ExchangeSpecificServiceLookup lookup = this.getService((Class<T>)ExchangeSpecificServiceLookup.class);
        return lookup.getExchangeSpecificService(serviceClass, exchange);
    }

    public <T> T getService(Class<T> serviceClass) {
        return this.injector.getInstance(serviceClass);
    }

    public <T> T getService(Class<T> serviceClass, Class<? extends Annotation> serviceAnnotation) {
        return this.injector.getInstance(Key.get(serviceClass, serviceAnnotation));
    }

    @Override
    public <I extends Comparable<I>, T extends BroadcastEntity<I>> SmallFastDataModel<I, T> getSmallDataModel(Class<T> forEntityClass) {
        return (SmallFastDataModel)this.getDataModel(forEntityClass);
    }

    @Override
    public <I extends Comparable<I>, T extends BroadcastEntity<I>> LargePersistableDataModel<I, T> getLargeDataModel(Class<T> entityClass) {
        return (LargePersistableDataModel)this.getDataModel(entityClass);
    }

    @Override
    public <I extends Comparable<I>, T extends BroadcastEntity<I>> DataModel<I, T> getDataModel(Class<T> entityClass) {
        return this.dataModels.computeIfAbsent(entityClass, this::createDataModelForClass);
    }

    private <I extends Comparable<I>, T extends BroadcastEntity<I>> DataModel<I, T> createDataModelForClass(Class<T> entityClass) {
        DataModel dataModel = this.injector.getInstance(DataModelFactory.class).createDataModel(this, entityClass);
        if (this.dataModelValid(entityClass, dataModel)) {
            this.injector.getInstance(EventBus.class).register(new LogoutCleanUpDataModelHandler(dataModel));
            this.injector.getInstance(BroadcastListenerHandlerForClass.class).registerBackendBroadcastListener(dataModel);
            return dataModel;
        }
        throw new IllegalArgumentException("Invalid datamodel for class " + String.valueOf(entityClass));
    }

    private <I extends Comparable<I>, T extends BroadcastEntity<I>> boolean dataModelValid(Class<T> entityClass, DataModel<I, T> model) {
        return SmallDataModelEntity.class.isAssignableFrom(entityClass) && model instanceof SmallFastDataModel || LargeDataModelEntity.class.isAssignableFrom(entityClass) && model instanceof LargePersistableDataModel;
    }

    private static final class LogoutCleanUpDataModelHandler {
        private final DataModel dataModel;

        private LogoutCleanUpDataModelHandler(DataModel dataModel) {
            this.dataModel = dataModel;
        }

        @Subscribe
        public void handleLogout(LogoutCleanUpDataModelEvent event) {
            try {
                this.dataModel.removeAll();
            }
            catch (RuntimeException e) {
                LOG.error("", e);
            }
        }
    }
}

