/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.core.entity;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class EntityFilters {
    public static <T, P> Predicate<T> propertyEquals(Function<T, P> property, P value) {
        return s -> Objects.equals(value, property.apply(s));
    }

    public static <T, P> Predicate<T> propertyNotNull(Function<T, P> property) {
        return s -> property.apply(s) != null;
    }

    public static <T extends BroadcastEntity> Predicate<T> id(T id) {
        return EntityFilters.propertyEquals(BroadcastEntity::getId, id);
    }

    public static <T extends BroadcastEntity> Predicate<T> startsWith(Function<T, String> textProperty, String prefix) {
        return t -> {
            String textValue = (String)textProperty.apply(t);
            return prefix == null || textValue != null && textValue.startsWith(prefix);
        };
    }

    public static <T extends BroadcastEntity> Predicate<T> endsWith(Function<T, String> textProperty, String suffix) {
        return t -> {
            String textValue = (String)textProperty.apply(t);
            return suffix == null || textValue != null && textValue.endsWith(suffix);
        };
    }

    public static <T extends BroadcastEntity> Predicate<T> containsIgnoreCase(Function<T, String> textProperty, String matchString) {
        return t -> {
            String textValue = (String)textProperty.apply(t);
            return matchString == null || textValue != null && textValue.toUpperCase().contains(matchString.toUpperCase());
        };
    }

    public static <T extends BroadcastEntity> Predicate<T> equalsIgnoreCase(Function<T, String> textProperty, String value) {
        return t -> StringUtils.equalsIgnoreCase((CharSequence)textProperty.apply(t), value);
    }

    public static <T extends BroadcastEntity> Predicate<T> startsWithIgnoreCase(Function<T, String> textProperty, String prefix) {
        return t -> StringUtils.startsWithIgnoreCase((CharSequence)textProperty.apply(t), prefix);
    }
}

