/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.datamodel.SmallFastDataModelBase;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BlockContract;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderbookDataModel
extends SmallFastDataModelBase<String, Orderbook> {
    private static final Logger LOG = LoggerFactory.getLogger(OrderbookDataModel.class);
    private final boolean isCrossedOrderbookLogEnabled;

    public OrderbookDataModel(final ApplicationContext applicationContext) {
        super(applicationContext);
        this.isCrossedOrderbookLogEnabled = applicationContext.getService(ApplicationConfigurationService.class).getBooleanApplicationProperty("withCrossedOrderbookLogging");
        applicationContext.getService(EventBus.class).register(this);
        applicationContext.getSmallDataModel(Order.class).registerListener(new AbstractDataModelListener<Order>(this){

            private DataModelListener.NotificationResult updateOrderbookEntry(Order order) {
                if ((Long)order.getId() > 0L) {
                    OrderbookQueries orderbookQueries = applicationContext.getService(OrderbookQueries.class);
                    orderbookQueries.findByContract(order.getContract()).forEach(ob -> ob.updateEntry(order));
                }
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyAdd(Order order) {
                return this.updateOrderbookEntry(order);
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        });
    }

    @Subscribe
    public void handleEntityLoadingFinished(EntityLoadingFinishedEvent<?> entityLoadingFinishedEvent) {
        if (entityLoadingFinishedEvent.getEntityClass().equals(Orderbook.class)) {
            this.entities.values().stream().filter(orderbook -> orderbook.getContract() != null && orderbook.getContract().getType().isBlock()).forEach(this::updateOrderbooksForVwapCalculation);
        }
    }

    @Override
    public Orderbook add(Orderbook broadcastEntity) {
        Orderbook oldOrderbook = (Orderbook)this.findById((String)broadcastEntity.getId());
        if (oldOrderbook == null) {
            Orderbook newOrderbook;
            if (broadcastEntity.getRevisionNumber() == Long.MAX_VALUE) {
                broadcastEntity.setRevisionNumber(-1L);
            }
            if ((newOrderbook = super.add(broadcastEntity)).getContract() != null && newOrderbook.getContract().getType().isBlock()) {
                this.updateOrderbooksForVwapCalculation(newOrderbook);
            }
            return this.checkCrossedOrderbook(newOrderbook);
        }
        oldOrderbook.merge(broadcastEntity);
        return this.checkCrossedOrderbook(oldOrderbook);
    }

    protected void updateOrderbooksForVwapCalculation(Orderbook orderbook) {
        if (orderbook.getContract().getType().isBlock()) {
            DeliveryArea deliveryArea = orderbook.getDeliveryArea();
            OrderbookQueries orderbookQueries = this.appContext.getService(OrderbookQueries.class);
            List<Orderbook> orderbooks = ((BlockContract)orderbook.getContract()).getUnderlyingContracts().stream().map(contract -> orderbookQueries.findByContractAndDeliveryArea((Contract)contract, deliveryArea)).filter(Optional::isPresent).map(Optional::get).toList();
            orderbook.updateOrderbooksForVwapCalculation(orderbooks);
        }
    }

    @Override
    public Class<Orderbook> getEntityClass() {
        return Orderbook.class;
    }

    @Override
    public void runCleanup() {
        TimeService timeService = this.appContext.getService(TimeService.class);
        DateTime exchangeDateTime = timeService.getServerTime();
        DateTime tomorrowStartOfDay = exchangeDateTime.plusDays(1).withTimeAtStartOfDay();
        DateTime todayEndOfDay = exchangeDateTime.withTimeAtStartOfDay();
        DateTime yesterdayEndOfDay = exchangeDateTime.minusDays(1).withTimeAtStartOfDay();
        this.getAllEntitiesAsStream().filter(orderbook -> orderbook.getClosingPrice() != null).filter(orderbook -> orderbook.getClosingPriceDate().isAfter(tomorrowStartOfDay) || orderbook.getClosingPriceDate().isBefore(todayEndOfDay)).forEach(orderbook -> {
            orderbook.setClosingPrice(null);
            orderbook.setClosingPriceDate(null);
        });
        this.getAllEntitiesAsStream().filter(orderbook -> orderbook.getOpeningPrice() != null).filter(orderbook -> orderbook.getOpeningPriceDate().isAfter(tomorrowStartOfDay) || orderbook.getOpeningPriceDate().isBefore(yesterdayEndOfDay)).forEach(orderbook -> {
            orderbook.setOpeningPrice(null);
            orderbook.setOpeningPriceDate(null);
        });
    }

    private Orderbook checkCrossedOrderbook(Orderbook orderbook) {
        if (this.isCrossedOrderbookLogEnabled) {
            SortedSet<OrderbookEntry> sortedEntriesB = orderbook.getBuys().getSortedEntries();
            SortedSet<OrderbookEntry> sortedEntriesS = orderbook.getSells().getSortedEntries();
            if (!sortedEntriesB.isEmpty() && !sortedEntriesS.isEmpty()) {
                OrderbookEntry firstBuy = sortedEntriesB.first();
                OrderbookEntry firstSell = sortedEntriesS.first();
                if (firstBuy.getPrice().compareTo(firstSell.getPrice()) >= 0 && LongDisplayValue.ZERO.compareTo(firstBuy.getQuantity()) < 0 && LongDisplayValue.ZERO.compareTo(firstSell.getQuantity()) < 0) {
                    LOG.warn("CrossedOrderbook buy: {} and sell: {}", (Object)firstBuy, (Object)firstSell);
                }
            }
        }
        return orderbook;
    }
}

