/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.entities.RevisionNumbered;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SmallFastDataModelBase<I extends Comparable<I>, T extends BroadcastEntity<I>>
implements SmallFastDataModel<I, T> {
    private static final Logger LOG = LoggerFactory.getLogger(SmallFastDataModelBase.class);
    protected final Map<I, T> entities = new ConcurrentHashMap<I, T>();
    protected final List<DataModelListener<T>> postListeners = new CopyOnWriteArrayList<DataModelListener<T>>();
    protected final List<DataModelListener<T>> preListeners = new CopyOnWriteArrayList<DataModelListener<T>>();
    protected final ApplicationContext appContext;

    protected SmallFastDataModelBase(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public void registerListener(DataModelListener<T> dataModelListener) {
        this.postListeners.add(dataModelListener);
        dataModelListener.notifyAddAll(this.entities.values());
    }

    @Override
    public void registerHencePostOperationListener(DataModelListener<T> dataModelListener) {
        this.postListeners.add(dataModelListener);
    }

    @Override
    public void registerHencePreOperationListener(DataModelListener<T> dataModelListener) {
        this.preListeners.add(dataModelListener);
    }

    @Override
    public void unregisterListener(DataModelListener<T> dataModelListener) {
        this.preListeners.remove(dataModelListener);
        this.postListeners.remove(dataModelListener);
    }

    @Override
    public Stream<T> getAllEntitiesAsStream() {
        return this.entities.values().stream();
    }

    @Override
    public T findById(I id) {
        return (T)(id != null ? (BroadcastEntity)this.entities.get(id) : null);
    }

    @Override
    public boolean containsKey(I id) {
        return this.entities.containsKey(id);
    }

    @Override
    public int size() {
        return this.entities.size();
    }

    public T add(T entity) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Adding {} (id:{}): {}", ClassUtils.getShortClassName(this.getEntityClass()), ((BroadcastEntity)entity).getId(), entity);
        }
        this.entities.put((Comparable)((BroadcastEntity)entity).getId(), entity);
        return entity;
    }

    public Set<T> addAll(Collection<T> entities) {
        HashSet<BroadcastEntity> set = new HashSet<BroadcastEntity>();
        for (BroadcastEntity entity : entities) {
            BroadcastEntity addedEntity = this.add(entity);
            if (addedEntity == null) continue;
            set.add(addedEntity);
        }
        return set;
    }

    @Override
    public T remove(T entity) {
        if (entity == null) {
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Removing {} (id:{}): {}", ClassUtils.getShortClassName(this.getEntityClass()), ((BroadcastEntity)entity).getId(), entity);
        }
        this.notifyRemoveListeners(entity, this.preListeners);
        BroadcastEntity removed = (BroadcastEntity)this.entities.remove(((BroadcastEntity)entity).getId());
        if (removed != null) {
            this.notifyRemoveListeners(entity, this.postListeners);
        }
        return (T)removed;
    }

    @Override
    public Collection<T> removeIf(Predicate<T> predicate) {
        HashSet<BroadcastEntity> removedEntities = new HashSet<BroadcastEntity>();
        Iterator<Map.Entry<I, T>> iterator2 = this.entities.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<I, T> entry = iterator2.next();
            if (!predicate.test((BroadcastEntity)entry.getValue())) continue;
            this.notifyRemoveListeners((BroadcastEntity)entry.getValue(), this.preListeners);
            iterator2.remove();
            removedEntities.add((BroadcastEntity)entry.getValue());
        }
        this.notifyRemoveListeners((Collection<T>)removedEntities, this.postListeners);
        return removedEntities;
    }

    @Override
    public void removeAll(Collection<T> entitiesToRemove) {
        this.notifyRemoveListeners(entitiesToRemove, this.preListeners);
        HashSet<BroadcastEntity> removedEntities = new HashSet<BroadcastEntity>();
        for (BroadcastEntity entity : entitiesToRemove) {
            BroadcastEntity removed = (BroadcastEntity)this.entities.remove(entity.getId());
            if (removed == null) continue;
            removedEntities.add(removed);
        }
        this.notifyRemoveListeners((Collection<T>)removedEntities, this.postListeners);
    }

    @Override
    public void removeAll() {
        this.notifyRemoveListeners(this.preListeners);
        this.entities.clear();
        this.notifyRemoveListeners(this.postListeners);
    }

    @Override
    public void handleBroadcastEntities(Collection<T> broadcastEntities) {
        if (broadcastEntities == null || broadcastEntities.isEmpty()) {
            return;
        }
        ArrayList<BroadcastEntity> updatedEntities = new ArrayList<BroadcastEntity>();
        ArrayList<BroadcastEntity> addedEntities = new ArrayList<BroadcastEntity>();
        for (BroadcastEntity broadcastEntity : broadcastEntities) {
            if (broadcastEntity == null) continue;
            if (this.entities.containsKey(broadcastEntity.getId())) {
                if (!this.isNewerVersionOfExistingEntity(broadcastEntity, (BroadcastEntity)this.entities.get(broadcastEntity.getId()))) continue;
                updatedEntities.add(broadcastEntity);
                continue;
            }
            addedEntities.add(broadcastEntity);
        }
        if (!updatedEntities.isEmpty()) {
            this.notifyUpdateListeners((Collection<T>)updatedEntities, this.preListeners);
            Set updatedEntitiesAfterAdd = this.addAll(updatedEntities);
            this.notifyUpdateListeners(updatedEntitiesAfterAdd, this.postListeners);
        }
        if (!addedEntities.isEmpty()) {
            this.notifyAddListeners((Collection<T>)addedEntities, this.preListeners);
            Set addedEntitiesAfterAdd = this.addAll(addedEntities);
            this.notifyAddListeners(addedEntitiesAfterAdd, this.postListeners);
        }
    }

    @Override
    public void handleBroadcastEntity(T broadcastEntity) {
        if (broadcastEntity == null) {
            return;
        }
        if (this.entities.containsKey(((BroadcastEntity)broadcastEntity).getId())) {
            if (this.isNewerVersionOfExistingEntity(broadcastEntity, (BroadcastEntity)this.entities.get(((BroadcastEntity)broadcastEntity).getId()))) {
                this.notifyUpdateListeners(broadcastEntity, this.preListeners);
                T addedEntity = this.add(broadcastEntity);
                if (addedEntity != null) {
                    this.notifyUpdateListeners(addedEntity, this.postListeners);
                }
            }
        } else {
            this.notifyAddListeners(broadcastEntity, this.preListeners);
            T addedEntity = this.add(broadcastEntity);
            if (addedEntity != null) {
                this.notifyAddListeners(addedEntity, this.postListeners);
            }
        }
    }

    protected boolean isNewerVersionOfExistingEntity(T broadcastEntity, T existingEntity) {
        if (!(broadcastEntity instanceof RevisionNumbered)) {
            return true;
        }
        long revisionNumberBroadcast = ((RevisionNumbered)broadcastEntity).getRevisionNumber();
        long revisionNumberExisting = ((RevisionNumbered)existingEntity).getRevisionNumber();
        if (revisionNumberExisting == revisionNumberBroadcast) {
            LOG.warn("Same revision numbers for new entity {} and existing one {}", (Object)broadcastEntity, (Object)existingEntity);
        } else if (revisionNumberExisting > revisionNumberBroadcast && LOG.isDebugEnabled()) {
            LOG.debug("Ignoring entity: {}, existing is not older: {}", (Object)broadcastEntity, (Object)existingEntity);
        }
        return revisionNumberExisting < revisionNumberBroadcast;
    }

    @Override
    public void runCleanup() {
    }

    private void notifyListeners(List<DataModelListener<T>> listeners, Function<DataModelListener<T>, DataModelListener.NotificationResult> resultFunction) {
        for (DataModelListener<T> listener : listeners) {
            try {
                if (resultFunction.apply(listener) != DataModelListener.NotificationResult.REMOVE_LISTENER) continue;
                listeners.remove(listener);
            }
            catch (RuntimeException e) {
                LOG.error("Error when calling a DataModelListener", e);
            }
        }
    }

    protected void notifyAddListeners(T object, List<DataModelListener<T>> listeners) {
        this.notifyListeners(listeners, listener -> listener.notifyAdd(object));
    }

    protected void notifyAddListeners(Collection<T> collection, List<DataModelListener<T>> listeners) {
        if (!collection.isEmpty()) {
            this.notifyListeners(listeners, listener -> listener.notifyAddAll(collection));
        }
    }

    protected void notifyUpdateListeners(T object, List<DataModelListener<T>> listeners) {
        this.notifyListeners(listeners, listener -> listener.notifyUpdate(object));
    }

    protected void notifyUpdateListeners(Collection<T> collection, List<DataModelListener<T>> listeners) {
        if (!collection.isEmpty()) {
            this.notifyListeners(listeners, listener -> listener.notifyUpdateAll(collection));
        }
    }

    protected void notifyRemoveListeners(T object, List<DataModelListener<T>> listeners) {
        this.notifyListeners(listeners, listener -> listener.notifyRemove(object));
    }

    protected void notifyRemoveListeners(Collection<T> collection, List<DataModelListener<T>> listeners) {
        if (!collection.isEmpty()) {
            this.notifyListeners(listeners, listener -> listener.notifyRemoveAll(collection));
        }
    }

    protected void notifyRemoveListeners(List<DataModelListener<T>> listeners) {
        this.notifyListeners(listeners, DataModelListener::notifyRemoveAll);
    }
}

