/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.datamodel.SmallFastDataModelBase;
import com.deutscheboerse.comxerv.comtrader.domain.query.CurrentTradingLimitQueries;
import com.deutscheboerse.comxerv.comtrader.domain.query.TradingLimitQueries;
import com.deutscheboerse.comxerv.comtrader.entities.CurrentTradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.TradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradingLimitState;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import org.joda.time.DateTime;

public class TradingLimitDataModel
extends SmallFastDataModelBase<String, TradingLimit> {
    private final TimeService timeService;

    public TradingLimitDataModel(ApplicationContext applicationContext) {
        super(applicationContext);
        this.timeService = this.appContext.getService(TimeService.class);
        this.appContext.getDataModel(CurrentTradingLimit.class).registerHencePostOperationListener(new AbstractDataModelListener<CurrentTradingLimit>(){

            @Override
            public DataModelListener.NotificationResult notifyUpdate(CurrentTradingLimit object) {
                TradingLimitDataModel.this.updateCurrentLimit(object);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyAdd(CurrentTradingLimit object) {
                TradingLimitDataModel.this.updateCurrentLimit(object);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        });
    }

    private void updateCurrentLimit(CurrentTradingLimit currentTradingLimit) {
        DateTime serverTime = this.timeService.getServerTime();
        this.getTradingLimitQueries().findByMemberId(currentTradingLimit.getMemberId()).addFilter(limit -> limit.isCurrent(serverTime)).addFilter(limit -> currentTradingLimit.getCurrency().equals(limit.getCurrency())).getFirst().ifPresent(tradingLimit -> tradingLimit.setCurrent(currentTradingLimit));
    }

    @Override
    public Class<TradingLimit> getEntityClass() {
        return TradingLimit.class;
    }

    @Override
    public TradingLimit add(TradingLimit newEntity) {
        this.updateLimit(newEntity);
        TradingLimit oldEntity = (TradingLimit)this.findById((String)newEntity.getId());
        if (oldEntity != null) {
            oldEntity.merge(newEntity);
            if (newEntity.getState() == TradingLimitState.INACTIVE) {
                this.remove(newEntity);
                return null;
            }
            return oldEntity;
        }
        if (newEntity.getState() == TradingLimitState.INACTIVE) {
            return null;
        }
        return super.add(newEntity);
    }

    private void updateLimit(TradingLimit limit) {
        if (limit.isCurrent(this.timeService.getServerTime())) {
            this.getCurrentTradingLimitQueries().findByMemberIdAndCurrency(limit.getMemberId(), limit.getCurrency()).getFirst().ifPresent(limit::setCurrent);
        }
    }

    private CurrentTradingLimitQueries getCurrentTradingLimitQueries() {
        return this.appContext.getService(CurrentTradingLimitQueries.class);
    }

    private TradingLimitQueries getTradingLimitQueries() {
        return this.appContext.getService(TradingLimitQueries.class);
    }
}

