/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.domain.query.HubToHubQueries;
import com.deutscheboerse.comxerv.comtrader.entities.AtcId;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHub;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.joda.time.Interval;

@Singleton
class HubToHubQueriesImpl
implements HubToHubQueries {
    private final SmallFastDataModel<AtcId, HubToHub> dataModel;

    @Inject
    public HubToHubQueriesImpl(ApplicationContext applicationContext) {
        this.dataModel = applicationContext.getSmallDataModel(HubToHub.class);
    }

    @Override
    public Set<String> getAllFromMarketAreaIds() {
        return this.dataModel.getAllEntitiesAsStream().map(a -> ((AtcId)a.getId()).getFromMarketAreaId()).collect(Collectors.toCollection(() -> new TreeSet(Comparator.naturalOrder())));
    }

    @Override
    public Set<HubToHub> getForInterval(Interval interval) {
        return this.dataModel.getAllEntitiesAsStream().filter(a -> a.getDeliveryPeriod().equals(interval)).collect(Collectors.toSet());
    }

    @Override
    public Multimap<Interval, HubToHub> createDeliveryPeriodEntityMultimap() {
        ArrayListMultimap<Interval, HubToHub> map = ArrayListMultimap.create();
        this.dataModel.getAllEntitiesAsStream().forEach(entity -> map.put(entity.getDeliveryPeriod(), (HubToHub)entity));
        return map;
    }
}

