/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.entities.RoundingException;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class LongDisplayValue
implements Comparable<LongDisplayValue>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long value;
    private final BigDecimal displayValue;
    private final int shift;
    public static final LongDisplayValue ZERO = new LongDisplayValue(0L, 0);
    public static final LongDisplayValue ONE = new LongDisplayValue(1L, 0);

    public LongDisplayValue() {
        this.value = 0L;
        this.shift = 0;
        this.displayValue = BigDecimal.ZERO;
    }

    public LongDisplayValue(long value, int shift) {
        this.value = value;
        this.shift = shift;
        this.displayValue = new BigDecimal(BigInteger.valueOf(value), shift);
    }

    public LongDisplayValue(BigDecimal displayValue) {
        this.displayValue = displayValue;
        this.shift = displayValue.scale();
        this.value = displayValue.setScale(this.shift, RoundingMode.HALF_UP).movePointRight(this.shift).longValue();
    }

    public static LongDisplayValue toZero(int shift) {
        return new LongDisplayValue(0L, shift);
    }

    public LongDisplayValue applyShift(int shift) {
        return new LongDisplayValue((long)((double)this.value * Math.pow(10.0, shift - this.shift)), shift);
    }

    public LongDisplayValue applyRoundedUpShift(int shift) {
        double computedValue = (double)this.value * Math.pow(10.0, shift - this.shift);
        return new LongDisplayValue((long)Math.ceil(computedValue), shift);
    }

    public long getValue() {
        return this.value;
    }

    public BigDecimal getDisplayValue() {
        return this.displayValue;
    }

    public int getShift() {
        return this.shift;
    }

    public LongDisplayValue invert() {
        return new LongDisplayValue(this.value * -1L, this.shift);
    }

    public LongDisplayValue add(long value) {
        return new LongDisplayValue(this.value + value, this.shift);
    }

    public LongDisplayValue subtract(long value) {
        return new LongDisplayValue(this.value - value, this.shift);
    }

    public LongDisplayValue add(BigDecimal displayValue) {
        int scale = displayValue.scale();
        if (scale > this.shift) {
            throw new RoundingException("The number you are adding has " + scale + " digits behind the comma but this value only supports " + this.shift + ".");
        }
        return new LongDisplayValue(this.value + displayValue.movePointRight(scale).longValue(), this.shift);
    }

    public LongDisplayValue subtract(BigDecimal displayValue) {
        return this.add(displayValue.negate());
    }

    public LongDisplayValue setRoundedValue(BigDecimal displayValue) {
        int scale = displayValue.scale();
        if (scale > this.shift) {
            return new LongDisplayValue(displayValue.setScale(this.shift, RoundingMode.HALF_UP).movePointRight(this.shift).longValue(), this.shift);
        }
        return new LongDisplayValue(displayValue.movePointRight(this.shift).longValue(), this.shift);
    }

    public LongDisplayValue roundedToIncrement(LongDisplayValue increment, IncrementRoundingMode mode) {
        if (increment.shift > this.shift) {
            LongDisplayValue thisShifted = this.applyShift(increment.getShift());
            if (thisShifted.value % increment.value == 0L) {
                return thisShifted;
            }
            if (mode == IncrementRoundingMode.DOWN) {
                return new LongDisplayValue(thisShifted.value - thisShifted.value % increment.value, thisShifted.shift);
            }
            return new LongDisplayValue(thisShifted.value - thisShifted.value % increment.value + increment.value, thisShifted.shift);
        }
        LongDisplayValue incrementCorrected = increment.applyShift(this.shift);
        if (mode == IncrementRoundingMode.DOWN) {
            return new LongDisplayValue(this.value - this.value % incrementCorrected.value, this.shift);
        }
        return new LongDisplayValue(this.value - this.value % incrementCorrected.value + incrementCorrected.value, this.shift);
    }

    public LongDisplayValue max(LongDisplayValue val) {
        return val == null || this.compareTo(val) >= 0 ? this : val;
    }

    public LongDisplayValue min(LongDisplayValue val) {
        return val == null || this.compareTo(val) <= 0 ? this : val;
    }

    @Override
    public int compareTo(LongDisplayValue o) {
        return this.displayValue.compareTo(o.displayValue);
    }

    public String toString() {
        return Util.format(this.displayValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongDisplayValue that = (LongDisplayValue)o;
        if (this.shift != that.shift) {
            return false;
        }
        return this.value == that.value;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + this.shift;
        return result;
    }

    public static LongDisplayValue valueOf(String value) {
        return new LongDisplayValue(BigDecimal.valueOf(Double.valueOf(value)));
    }

    public LongDisplayValue toZero() {
        return new LongDisplayValue(0L, this.shift);
    }

    public static enum IncrementRoundingMode {
        UP,
        DOWN;

    }
}

