/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.SmallDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.CurrentTradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Mergeable;
import com.deutscheboerse.comxerv.comtrader.entities.RevisionNumbered;
import com.deutscheboerse.comxerv.comtrader.entities.type.LimitType;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradingLimitState;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class TradingLimit
extends BroadcastEntity<String>
implements RevisionNumbered,
Mergeable<TradingLimit>,
SmallDataModelEntity {
    private final ObjectProperty<LongDisplayValue> initial = new SimpleObjectProperty<LongDisplayValue>();
    private final ObjectProperty<LimitType> limitType = new SimpleObjectProperty<LimitType>();
    private final ObjectProperty<Long> revisionNumber = new SimpleObjectProperty<Long>();
    private final StringProperty memberId = new SimpleStringProperty();
    private final ObjectProperty<Long> contractId = new SimpleObjectProperty<Long>();
    private final ObjectProperty<Contract> contract = new SimpleObjectProperty<Contract>();
    private final ObjectProperty<LocalDate> startDate = new SimpleObjectProperty<LocalDate>();
    private final ObjectProperty<LocalDate> endDate = new SimpleObjectProperty<LocalDate>();
    private final ObjectProperty<String> currency = new SimpleObjectProperty<String>();
    private final ObjectProperty<TradingLimitState> state = new SimpleObjectProperty<TradingLimitState>();
    private final ObjectProperty<CurrentTradingLimit> current = new SimpleObjectProperty<CurrentTradingLimit>(new CurrentTradingLimit());

    @Override
    public Class getEntityClass() {
        return TradingLimit.class;
    }

    @Override
    public void merge(TradingLimit object) {
        this.setRevisionNumber(object.getRevisionNumber());
        this.setInitial(object.getInitial());
        this.setLimitType(object.getLimitType());
        this.setContract(object.getContract());
        this.setContractId(object.getContractId());
        this.setStartDate(object.getStartDate());
        this.setEndDate(object.getEndDate());
        this.setCurrency(object.getCurrency());
        this.setState(object.getState());
        this.setCurrent(object.getCurrent());
    }

    public LongDisplayValue getInitial() {
        return (LongDisplayValue)this.initial.get();
    }

    public ObjectProperty<LongDisplayValue> initialProperty() {
        return this.initial;
    }

    public void setInitial(LongDisplayValue initial) {
        this.initial.set(initial);
    }

    public LimitType getLimitType() {
        return (LimitType)this.limitType.get();
    }

    public ObjectProperty<LimitType> limitTypeProperty() {
        return this.limitType;
    }

    public void setLimitType(LimitType limitType) {
        this.limitType.set(limitType);
    }

    @Override
    public long getRevisionNumber() {
        return (Long)this.revisionNumber.get();
    }

    public ObjectProperty<Long> revisionNumberProperty() {
        return this.revisionNumber;
    }

    public void setRevisionNumber(Long revisionNumber) {
        this.revisionNumber.set(revisionNumber);
    }

    public String getMemberId() {
        return (String)this.memberId.get();
    }

    public StringProperty memberIdProperty() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId.set(memberId);
    }

    public Long getContractId() {
        return (Long)this.contractId.get();
    }

    public ObjectProperty<Long> contractIdProperty() {
        return this.contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId.set(contractId);
    }

    public Contract getContract() {
        return (Contract)this.contract.get();
    }

    public ObjectProperty<Contract> contractProperty() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract.set(contract);
    }

    public LocalDate getStartDate() {
        return (LocalDate)this.startDate.get();
    }

    public ObjectProperty<LocalDate> startDateProperty() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return (LocalDate)this.endDate.get();
    }

    public ReadOnlyObjectProperty<LocalDate> endDateProperty() {
        return this.endDate;
    }

    public String getCurrency() {
        return (String)this.currency.get();
    }

    public ObjectProperty<String> currencyProperty() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency.set(currency);
    }

    public TradingLimitState getState() {
        return (TradingLimitState)((Object)this.state.get());
    }

    public ReadOnlyObjectProperty<TradingLimitState> stateProperty() {
        return this.state;
    }

    public void setState(TradingLimitState state) {
        this.state.set(state);
    }

    public CurrentTradingLimit getCurrent() {
        return (CurrentTradingLimit)this.current.get();
    }

    public ObjectProperty<CurrentTradingLimit> currentProperty() {
        return this.current;
    }

    public void setCurrent(CurrentTradingLimit current) {
        this.current.set(current);
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate.set(startDate);
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate.set(endDate);
    }

    public String toString() {
        return "TradingLimit{initial=" + String.valueOf(this.initial.get()) + ", limitType=" + String.valueOf(this.limitType.get()) + ", revisionNumber=" + String.valueOf(this.revisionNumber.get()) + ", memberId=" + (String)this.memberId.get() + ", contractId=" + String.valueOf(this.contractId.get()) + ", contract=" + String.valueOf(this.contract.get()) + ", startDate=" + String.valueOf(this.startDate.get()) + ", endDate=" + String.valueOf(this.endDate.get()) + ", currency=" + (String)this.currency.get() + ", state=" + String.valueOf(this.state.get()) + ", current=" + String.valueOf(this.current.get()) + "}";
    }

    public boolean isCurrent(DateTime now) {
        return this.getState() == TradingLimitState.ACTIVE && now.compareTo(this.getStartDate().toDateTimeAtStartOfDay()) >= 0 && (this.getEndDate() == null || now.compareTo(this.getEndDate().plusDays(1).toDateTimeAtStartOfDay()) <= 0);
    }
}

