/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface UserRoles {
    public static final String ROLE_ADMIN = "ROLE_ADMIN";
    public static final String ROLE_DATA_VENDOR = "ROLE_DATA_VENDOR";
    public static final String ROLE_OWN_TRADING = "ROLE_OWN_TRADING";
    public static final String ROLE_TRADEFILE = "ROLE_TRADEFILE";
    public static final String ROLE_USER = "ROLE_USER";
    public static final String ROLE_BALANCE_USER = "ROLE_BALANCE_USER";
    public static final String ROLE_CAPACITY_INFO = "ROLE_CAPACITY_INFO";
    public static final String ROLE_EPEX_SALES = "ROLE_EPEX_SALES";
    public static final String ROLE_ON_BEHALF = "ROLE_ON_BEHALF";
    public static final String ROLE_BROKER = "ROLE_BROKER";
    public static final String ROLE_MARKET_MAKER = "ROLE_MARKET_MAKER";
    public static final String ROLE_MODIFY_TRADE = "ROLE_MODIFY_TRADE";
    public static final String ROLE_REGULAR_TRADING = "ROLE_REGULAR_TRADING";
    public static final String ROLE_REDISPATCH_BALANCE_USER = "ROLE_REDISPATCH_BALANCE_USER";
    public static final List<String> ALL_ROLES = Collections.unmodifiableList(Arrays.asList("ROLE_ADMIN", "ROLE_DATA_VENDOR", "ROLE_OWN_TRADING", "ROLE_TRADEFILE", "ROLE_USER", "ROLE_BALANCE_USER", "ROLE_CAPACITY_INFO", "ROLE_EPEX_SALES", "ROLE_ON_BEHALF", "ROLE_BROKER", "ROLE_MARKET_MAKER", "ROLE_MODIFY_TRADE", "ROLE_REGULAR_TRADING", "ROLE_REDISPATCH_BALANCE_USER"));

    default public boolean isAdmin() {
        return this.hasRole(ROLE_ADMIN);
    }

    default public boolean isDataVendor() {
        return this.hasRole(ROLE_DATA_VENDOR);
    }

    default public boolean isTrader() {
        return this.hasRole(ROLE_USER) || this.hasRole(ROLE_REGULAR_TRADING);
    }

    default public boolean isBalanceUser() {
        return this.hasRole(ROLE_BALANCE_USER) || this.hasRole(ROLE_REDISPATCH_BALANCE_USER);
    }

    default public boolean isCapacityInfo() {
        return this.hasRole(ROLE_CAPACITY_INFO);
    }

    default public boolean isTradeFile() {
        return this.hasRole(ROLE_TRADEFILE);
    }

    default public boolean isSalesUser() {
        return this.hasRole(ROLE_EPEX_SALES);
    }

    default public boolean isOnBehalf() {
        return this.hasRole(ROLE_ON_BEHALF);
    }

    default public boolean isBroker() {
        return this.hasRole(ROLE_BROKER);
    }

    default public boolean isOwnTrading() {
        return this.hasRole(ROLE_OWN_TRADING);
    }

    default public boolean isMarketMaker() {
        return this.hasRole(ROLE_MARKET_MAKER);
    }

    default public boolean isModifyTrade() {
        return this.hasRole(ROLE_MODIFY_TRADE);
    }

    default public boolean isAbleToSeeFullTrades() {
        return this.isAdmin() || this.isBroker() || this.isSalesUser();
    }

    default public boolean hasAssignments() {
        return this.isTrader() || this.isDataVendor() || this.isBalanceUser();
    }

    public boolean hasRole(String var1);

    public static class SimpleRoleSet
    implements UserRoles {
        private Set<String> roles;

        public SimpleRoleSet() {
            this.roles = new HashSet<String>();
        }

        public SimpleRoleSet(String ... roles) {
            this(Arrays.asList(roles));
        }

        public SimpleRoleSet(Collection<String> roles) {
            this.roles = new HashSet<String>(roles);
        }

        @Override
        public boolean hasRole(String role) {
            return this.roles.contains(role);
        }

        public String toString() {
            return this.roles.toString();
        }
    }
}

