/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.AbstractComputedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.PriceGroupedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.PriceGroupedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import java.util.Collections;
import java.util.Comparator;

public class OutrightPriceGroupedOrderbookEntries
extends AbstractComputedOrderbookEntries<PriceGroupedOrderbookEntry>
implements PriceGroupedOrderbookEntries {
    protected OutrightPriceGroupedOrderbookEntries(Orderbook orderbook, Direction direction) {
        super(orderbook, direction);
        this.populateEntries();
    }

    @Override
    protected void loadBestEntryValue() {
        this.bestEntry.setPrice(((PriceGroupedOrderbookEntry)this.entries.get(0)).getPrice());
        this.bestEntry.setQuantity(((PriceGroupedOrderbookEntry)this.entries.get(0)).getQuantity());
        this.bestEntry.setOwnQuantity(((PriceGroupedOrderbookEntry)this.entries.get(0)).getOwnQuantity());
        this.bestEntry.setSource(((PriceGroupedOrderbookEntry)this.entries.get(0)).getSource());
    }

    private void populateEntries() {
        this.rawEntries.getEntries().forEach(this::rawEntryAdded);
        this.updateDirtyEntries();
        this.reloadVwapAndAccQty(0);
        this.updateBestEntry();
        this.reloadAccumulatedTradable();
    }

    @Override
    protected void rawEntriesBatchUpdateFinished(int minIndexChanged) {
        this.updateDirtyEntries();
        if (this.size() > 0) {
            int indexBeforeMinIndexChanged = Math.max(minIndexChanged - 1, 0);
            PriceGroupedOrderbookEntry entryBeforeChanged = (PriceGroupedOrderbookEntry)this.entries.get(indexBeforeMinIndexChanged);
            boolean accumulatedTradable = minIndexChanged < this.size() && (indexBeforeMinIndexChanged == 0 ? entryBeforeChanged.getTradableQuantity().equals(entryBeforeChanged.getQuantity()) : entryBeforeChanged.isAccumulatedTradable());
            for (int i = indexBeforeMinIndexChanged; i < this.size(); ++i) {
                ((PriceGroupedOrderbookEntry)this.entries.get(i)).setAccumulatedTradable(accumulatedTradable &= ((PriceGroupedOrderbookEntry)this.entries.get(i)).getQuantity().equals(((PriceGroupedOrderbookEntry)this.entries.get(i)).getTradableQuantity()));
            }
        }
        super.rawEntriesBatchUpdateFinished(minIndexChanged);
    }

    private void updateDirtyEntries() {
        this.entries.forEach(PriceGroupedOrderbookEntry::update);
    }

    @Override
    protected int rawEntryAdded(OrderbookEntry rawEntry) {
        PriceGroupedOrderbookEntry entry;
        LongDisplayValue price = rawEntry.getPrice();
        int quantityShift = rawEntry.getQuantity().getShift();
        int index = this.find(price);
        if (index >= 0) {
            entry = (PriceGroupedOrderbookEntry)this.entries.get(index);
        } else {
            entry = new PriceGroupedOrderbookEntry(this.orderbook, price, quantityShift, this.getDirection(), rawEntry.getLocalTimestamp());
            index = -index - 1;
            this.entries.add(index, entry);
        }
        entry.add(rawEntry);
        entry.addTradableQuantity(rawEntry);
        return index;
    }

    @Override
    protected int rawEntryRemoved(OrderbookEntry rawEntry) {
        LongDisplayValue price = rawEntry.getPrice();
        int index = this.find(price);
        if (index >= 0) {
            PriceGroupedOrderbookEntry entry = (PriceGroupedOrderbookEntry)this.entries.get(index);
            entry.remove(rawEntry);
            entry.removeTradableQuantity(rawEntry);
            if (entry.isEmpty()) {
                return index;
            }
            return -index - 1;
        }
        throw new IllegalStateException("Price-grouped entries doesn't contain an entry with the price of the specified raw entry.");
    }

    protected int find(LongDisplayValue price) {
        PriceGroupedOrderbookEntry searchKey = new PriceGroupedOrderbookEntry(this.orderbook, price, 0, this.getDirection(), 0L);
        Comparator<PriceGroupedOrderbookEntry> comparator = PriceGroupedOrderbookEntry.getDefaultComparator(this.getDirection());
        return Collections.binarySearch(this.entries, searchKey, comparator);
    }

    @Override
    protected void reloadOwnQuantities() {
        this.entries.forEach(PriceGroupedOrderbookEntry::resetOwnQuantity);
        for (OrderbookEntry rawEntry : this.rawEntries.getEntries()) {
            int index = this.find(rawEntry.getPrice());
            if (index < 0) continue;
            PriceGroupedOrderbookEntry entry = (PriceGroupedOrderbookEntry)this.entries.get(index);
            entry.addOwnQuantity(rawEntry);
        }
        this.updateDirtyEntries();
        this.updateBestEntry();
    }

    @Override
    protected void reloadTradability() {
        this.entries.forEach(PriceGroupedOrderbookEntry::resetTradability);
        this.rawEntries.getEntriesAsCollection().forEach(rawEntry -> {
            PriceGroupedOrderbookEntry entry = (PriceGroupedOrderbookEntry)this.getEntries().get(this.find(rawEntry.getPrice()));
            entry.addTradableQuantity((OrderbookEntry)rawEntry);
        });
        this.entries.forEach(PriceGroupedOrderbookEntry::update);
        this.reloadAccumulatedTradable();
    }

    private void reloadAccumulatedTradable() {
        boolean accumulatedTradable = true;
        for (PriceGroupedOrderbookEntry entry : this.entries) {
            entry.setAccumulatedTradable(accumulatedTradable &= entry.getQuantity().equals(entry.getTradableQuantity()));
        }
    }
}

