/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.MasterLoginModel;
import com.deutscheboerse.comxerv.comtrader.app.login.MasterLoginWindow;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.GuiMessageRecorder;
import com.deutscheboerse.comxerv.comtrader.jfx.GuiMessageSender;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AboutPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ContentTab;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.SettingsPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.TabPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.aware.label.LabelKeyAware;
import com.deutscheboerse.comxerv.comtrader.jfx.components.aware.label.LabelKeyAwareMenuItem;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.ClockPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.OnBehalfInfoBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbar;
import com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel.AllOrderActionButtons;
import com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel.GlobalKeyboardShortcuts;
import com.deutscheboerse.comxerv.comtrader.jfx.components.state.PanelWithBottomToolbarState;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurations;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AllDescendantsByIdOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.BottomToolbarOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.MenuBarOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.service.CloseConfirmationService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.GuiStateService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MainPanelService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MasterProfileService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.StageWithSuffix;
import com.deutscheboerse.comxerv.comtrader.jfx.service.WindowStateStorage;
import com.deutscheboerse.comxerv.comtrader.jfx.service.manual.ManualService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.user.ChangePasswordUiService;
import com.deutscheboerse.comxerv.comtrader.service.GlobalOrderbookSettingsService;
import com.deutscheboerse.comxerv.comtrader.service.LogoutService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileManager;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.comxerv.comtrader.util.FileUtil;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.event.AcceleratorEvent;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

@OverrideGuiConfigurations(value={@OverrideGuiConfiguration(field="bottomToolbar", overrideId="MainPanel", strategy=BottomToolbarOverrideGuiStrategy.class), @OverrideGuiConfiguration(field="allOrderActionButtons", overrideId="AllOrderActionButtons", strategy=AllDescendantsByIdOverrideGuiStrategy.class), @OverrideGuiConfiguration(field="menuBar", overrideId="MainPanel", strategy=MenuBarOverrideGuiStrategy.class)})
public class MainPanel
extends FXMLBorderPane
implements Destroyable {
    private final StageWithSuffix stage;
    private final WindowStateStorage windowStateStorage;
    private final MainPanelService mainPanelService;
    private final MasterProfileService masterProfileService;
    private final ProfileManager profileManager;
    private final GuiStateService guiStateService;
    private final CloseConfirmationService closeConfirmationService;
    private final UserAlertService userAlertService;
    private final OnBehalfService onBehalfService;
    private final TabPanel tabPanel;
    private final MasterLoginModel masterLoginModel;
    @FXML
    private BottomToolbar bottomToolbar;
    @FXML
    private MenuBar menuBar;
    @FXML
    private LabelKeyAwareMenuItem newDialogMenuItem;
    @FXML
    private LabelKeyAwareMenuItem hideShowProductNavigatorMenuItem;
    @FXML
    private LabelKeyAwareMenuItem saveConfigMenuItem;
    @FXML
    private LabelKeyAwareMenuItem toggleTabsMenuItem;
    @FXML
    private LabelKeyAwareMenuItem editComponentMenuItem;
    @FXML
    private LabelKeyAwareMenuItem exitMenuItem;
    @FXML
    private LabelKeyAwareMenuItem manualMenuItem;
    @FXML
    private LabelKeyAwareMenuItem recordMessagesMenuItem;
    @FXML
    private OnBehalfInfoBox onBehalfInfoBox;
    @FXML
    private ClockPanel clockPanel;
    @FXML
    private AllOrderActionButtons allOrderActionButtons;
    private ChangeListener<Boolean> productNavigatorVisibilityListener;

    public MainPanel(ApplicationContext appContext, StageWithSuffix stage) {
        super(appContext);
        this.stage = stage;
        this.windowStateStorage = new WindowStateStorage(appContext);
        this.mainPanelService = appContext.getService(MainPanelService.class);
        this.masterProfileService = appContext.getService(MasterProfileService.class);
        this.profileManager = appContext.getService(ProfileManager.class);
        this.guiStateService = appContext.getService(GuiStateService.class);
        this.closeConfirmationService = appContext.getService(CloseConfirmationService.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.onBehalfService = appContext.getService(OnBehalfService.class);
        this.masterLoginModel = appContext.getService(MasterLoginModel.class);
        this.tabPanel = new TabPanel(appContext, this);
        this.loadFxml();
    }

    public void initialize() {
        this.windowStateStorage.restoreStageState(this.getSuffixStage());
        this.toggleTabsMenuItem.disableProperty().bind(this.guiStateService.editModeProperty());
        this.toggleTabsMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.T, KeyCombination.ALT_DOWN));
        this.editComponentMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.C, KeyCombination.ALT_DOWN));
        this.exitMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.F4, KeyCombination.ALT_DOWN));
        this.addEventFilter(KeyEvent.KEY_PRESSED, new AcceleratorEvent(this.exitMenuItem, KeyCode.F4, KeyCombination.ALT_DOWN));
        this.recordMessagesMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.R, KeyCombination.CONTROL_DOWN, KeyCombination.ALT_DOWN));
        this.newDialogMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.N, KeyCombination.ALT_DOWN));
        this.hideShowProductNavigatorMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.P, KeyCombination.ALT_DOWN));
        this.saveConfigMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.S, KeyCombination.CONTROL_DOWN));
        this.manualMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.F1, new KeyCombination.Modifier[0]));
        this.clockPanel.disableProperty().bind(this.guiStateService.editModeProperty());
        this.onBehalfInfoBox.disableProperty().bind(this.guiStateService.editModeProperty());
        this.setMinSize(this.getStage().getWidth(), this.getStage().getHeight());
        this.getStage().addEventFilter(KeyEvent.KEY_PRESSED, this.getAppContext().getService(GlobalKeyboardShortcuts.class));
        this.getAppContext().getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(this);
        InvalidationListener invalidationListener = observable2 -> {
            if (this.tabPanel.getVisibleTabs().booleanValue()) {
                this.toggleTabsMenuItem.setLabelId("commons_hideTabs");
            } else {
                this.toggleTabsMenuItem.setLabelId("commons_showTabs");
            }
        };
        this.tabPanel.visibleTabsProperty().addListener(invalidationListener);
        this.setCenter(this.tabPanel);
        invalidationListener.invalidated(null);
        GlobalOrderbookSettingsService globalOrderbookSettings = this.getAppContext().getService(GlobalOrderbookSettingsService.class);
        this.productNavigatorVisibilityListener = (observableValue, aBoolean, newVisibility) -> {
            if (newVisibility.booleanValue()) {
                this.hideShowProductNavigatorMenuItem.setLabelId("commons_hideInstrumentNavigators");
            } else {
                this.hideShowProductNavigatorMenuItem.setLabelId("comXervClient_menuItem_showProductNavigator");
            }
        };
        WeakChangeListener<Boolean> weakProductNavigatorVisibilityListener = new WeakChangeListener<Boolean>(this.productNavigatorVisibilityListener);
        globalOrderbookSettings.visibilityOfProductNavigatorProperty().addListener(weakProductNavigatorVisibilityListener);
        this.productNavigatorVisibilityListener.changed(null, null, globalOrderbookSettings.getVisibilityOfProductNavigator());
    }

    public void storeStateInWindowStateStorage() {
        if (this.getCenter() instanceof TabPanel) {
            this.windowStateStorage.storeFXmlContent(this.tabPanel, this.getSuffix());
        } else {
            ((Tab)this.tabPanel.getSelectionModel().getSelectedItem()).setContent(((BorderPane)this.getCenter()).getCenter());
            this.windowStateStorage.storeFXmlContent(this.tabPanel, this.getSuffix());
            this.toggleTabs();
        }
    }

    public AllOrderActionButtons getAllOrderActionButtons() {
        return this.allOrderActionButtons;
    }

    @Override
    public void destroy() {
        this.allOrderActionButtons.destroy();
        this.destroyChildrenRecursively(this);
    }

    @FXML
    public void showLoginDialog() {
        this.getAppContext().getService(MasterLoginWindow.class).showLoginWindow();
    }

    @FXML
    public void logout() {
        this.getAppContext().getService(LogoutService.class).logout();
        this.getAppContext().getService(MasterLoginWindow.class).resetTitle();
    }

    @FXML
    public void exit() {
        this.closeConfirmationService.applicationExitRequested();
    }

    @FXML
    public void editComponent() {
        this.guiStateService.toggleEditMode();
    }

    @FXML
    public void finishEditMode() {
        this.guiStateService.stopEditMode();
    }

    @FXML
    public void newDialog() {
        this.mainPanelService.createMainPanelAndSetToEdit();
    }

    public String getSuffix() {
        return this.stage.getSuffix();
    }

    @FXML
    public void restoreSavedMainPanels() {
        this.masterProfileService.loadSavedProfile(true);
    }

    public void restoreComponents() {
        PanelWithBottomToolbarState state = this.getGeneralState();
        this.restoreMenuLabels();
        this.restoreState(state);
        this.tabPanel.setVisibleTabs(true);
        this.tabPanel.removeAllTabs();
        this.windowStateStorage.loadFXmlContent(this.getAppContext(), this.getSuffix(), this.tabPanel);
        this.tabPanel.getTabs().stream().filter(ContentTab.class::isInstance).map(ContentTab.class::cast).forEach(ContentTab::restoreComponents);
        this.guiStateService.stopEditMode();
    }

    private void restoreMenuLabels() {
        this.allOrderActionButtons.restoreLabels();
        this.menuBar.getMenus().forEach(this::restoreMenuItemLabel);
    }

    private void restoreMenuItemLabel(MenuItem menuItem) {
        if (menuItem instanceof LabelKeyAware) {
            ((LabelKeyAware)((Object)menuItem)).reloadLabel();
        }
        if (menuItem instanceof Menu) {
            ((Menu)menuItem).getItems().forEach(this::restoreMenuItemLabel);
        }
    }

    @FXML
    public void defaultMainPanels() {
        this.masterProfileService.loadDefaultProfile(true);
    }

    @FXML
    public void recordMessages() {
        this.getAppContext().getService(GuiMessageRecorder.class).activateRecording();
    }

    @FXML
    public void sendMessage() {
        this.getAppContext().getService(GuiMessageSender.class).showDialog();
    }

    @FXML
    public void openSettings() {
        SettingsPanel settingsPanel = new SettingsPanel(this.getAppContext());
        settingsPanel.showSettingsPanel();
    }

    @FXML
    public void retrieveLogs() {
        FileUtil.openLogFileFolder();
    }

    @FXML
    public void exportProfile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(Util.getLabel("commons_exportProfile"));
        fileChooser.setInitialFileName(this.masterLoginModel.getMasterUsername() + ".xml");
        FileChooser.ExtensionFilter xmlFilter = new FileChooser.ExtensionFilter(Util.getLabel("commons_xmlFilesFilter"), "*.xml");
        FileChooser.ExtensionFilter allFilter = new FileChooser.ExtensionFilter(Util.getLabel("commons_allFiles"), "*.*");
        fileChooser.getExtensionFilters().addAll((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{xmlFilter, allFilter});
        File exportFile = fileChooser.showSaveDialog(new Stage(StageStyle.DECORATED));
        if (exportFile != null) {
            this.profileManager.exportProfile(exportFile);
        }
    }

    @FXML
    public void importProfile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(Util.getLabel("commons_importProfile"));
        FileChooser.ExtensionFilter xmlFilter = new FileChooser.ExtensionFilter(Util.getLabel("commons_xmlFilesFilter"), "*.xml");
        FileChooser.ExtensionFilter allFilter = new FileChooser.ExtensionFilter(Util.getLabel("commons_allFiles"), "*.*");
        fileChooser.getExtensionFilters().addAll((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{xmlFilter, allFilter});
        fileChooser.setSelectedExtensionFilter(xmlFilter);
        File importFile = fileChooser.showOpenDialog(new Stage(StageStyle.DECORATED));
        if (importFile != null && importFile.exists()) {
            this.masterProfileService.importAndLoadProfile(importFile);
        }
    }

    @FXML
    public void saveConfiguration() {
        this.masterProfileService.saveConfiguration();
    }

    public void forceDisplayAllTabs(CountDownLatch countDownOnFinished) {
        this.tabPanel.forceDisplayAllTabs(countDownOnFinished);
    }

    public TabPanel getTabPanel() {
        return this.tabPanel;
    }

    public Stage getStage() {
        return this.stage.getStage();
    }

    public StageWithSuffix getSuffixStage() {
        return this.stage;
    }

    @FXML
    public void hideShowProductNavigator() {
        GlobalOrderbookSettingsService globalOrderbookSettingsService;
        Boolean visibleOfProductNavigator = (globalOrderbookSettingsService = this.getAppContext().getService(GlobalOrderbookSettingsService.class)).getVisibilityOfProductNavigator();
        globalOrderbookSettingsService.setVisibilityOfProductNavigator(visibleOfProductNavigator == false);
    }

    @FXML
    public void openAboutDialog() {
        this.getAppContext().getService(AboutPanel.class).showDialog();
    }

    @FXML
    public void openManualDialog() {
        this.getAppContext().getService(ManualService.class).showManual();
    }

    @FXML
    public void toggleTabs() {
        this.tabPanel.setVisibleTabs(this.tabPanel.getVisibleTabs() == false);
    }

    public PanelWithBottomToolbarState getGeneralState() {
        return new PanelWithBottomToolbarState(this.bottomToolbar.getState());
    }

    public void restoreState(PanelWithBottomToolbarState state) {
        if (state != null) {
            this.bottomToolbar.applyToolbarItemState(state.getBottomToolbarStoredState());
        }
    }

    @FXML
    public void changePasswordMenuItem() {
        if (this.onBehalfService.getOnBehalfUser() != null) {
            this.userAlertService.showConfirmationDialog(Util.getLabel("commons_changePasswordError"), Util.getLabel("commons_changePasswordOnBehalf"), UserAlertService.Flag.WARNING);
        } else {
            this.getAppContext().getService(ChangePasswordUiService.class).showChangePasswordUi(this.stage.getStage());
        }
    }

    @FXML
    public void totpPasswordMenuItem() {
        this.getAppContext().getService(ChangePasswordUiService.class).showTotpPasswordUi(this.stage.getStage());
    }

    public BottomToolbar getBottomToolbar() {
        return this.bottomToolbar;
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }
}

