/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.datamodel.FullTradeDataModel;
import com.deutscheboerse.comxerv.comtrader.domain.query.HalfTradeQueries;
import com.deutscheboerse.comxerv.comtrader.domain.query.TradeQueries;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractTradePanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.TotalsCounter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.LabeledBottomToolbarButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.FilteredTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ui.FilterPopupButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage.StorableTableLayoutDescriptor;
import com.deutscheboerse.comxerv.comtrader.jfx.components.trade.RelevantHalfTradeProvider;
import com.deutscheboerse.comxerv.comtrader.jfx.components.trade.TradePanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurations;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.BottomToolbarOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.TableViewOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeService;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@DraggableComponent(hasPublicAccess=true, nameKey="ownTradePanel_header_label", descriptionKey="ownTradePanel_description")
@PanelWithLoadingIndicator(entityClasses={FullTrade.class})
@OverrideGuiConfigurations(value={@OverrideGuiConfiguration(field="tableView", overrideId="OwnTradePanel", strategy=TableViewOverrideGuiStrategy.class), @OverrideGuiConfiguration(field="bottomToolbar", overrideId="OwnTradePanel", strategy=BottomToolbarOverrideGuiStrategy.class)})
public class OwnTradePanel
extends AbstractTradePanel<HalfTrade> {
    private final ObservableValue<User> selectedOnBehalfUser;
    private final TradeService tradeService = this.getAppContext().getService(TradeService.class);
    private final InvalidationListener onBehalfUserChange;
    private FilteredTableView<HalfTrade> filteredTableView;
    @FXML
    private FilterPopupButton<HalfTrade> filterButton;
    @FXML
    private LabeledBottomToolbarButton recallTradeButton;
    @FXML
    private TotalsCounter totalsCounter;

    public OwnTradePanel(ApplicationContext appContext) {
        super(appContext);
        this.selectedOnBehalfUser = appContext.getService(OnBehalfService.class).onBehalfUserProperty();
        this.onBehalfUserChange = o -> this.filteredTableView.setBaseFilter(this.baseFilter());
        this.selectedOnBehalfUser.addListener(new WeakInvalidationListener(this.onBehalfUserChange));
        this.loadFxml();
    }

    public OwnTradePanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    private void reloadDateQuickFilter() {
        Predicate<HalfTrade> dateFilter = this.dateFilterComponent.getFilter();
        Predicate<HalfTrade> decomposedTradesFilter = this.showDecomposedTrades.getHalfTraderFilter();
        this.filteredTableView.setQuickFilter(dateFilter.and(decomposedTradesFilter));
    }

    @Override
    public void initialize() {
        super.initialize();
        FullTradeDataModel dataModel = (FullTradeDataModel)this.getAppContext().getLargeDataModel(FullTrade.class);
        TradeQueries tradeQueries = this.getAppContext().getService(HalfTradeQueries.class);
        this.filteredTableView = new FilteredTableView<HalfTrade>(this.tradeTableView, this.baseFilter(), new RelevantHalfTradeProvider(tradeQueries, this.dateFilterComponent, dataModel), true);
        this.reloadDateQuickFilter();
        this.dateFilterComponent.removeTimeFramePaginationControls();
        this.dateFilterComponent.filterProperty().addListener(o -> this.reloadDateQuickFilter());
        this.showDecomposedTrades.halfTraderFilterProperty().addListener(o -> this.reloadDateQuickFilter());
        this.recallTradeButton.disableProperty().bind(DependentBinding.get(this::disableTradeRecallButton, this.getSelectedItems()));
        this.filterButton.initialize(this.filteredTableView);
        this.totalsCounter.shownItemsProperty().bind(this.filteredTableView.shownItems());
        this.totalsCounter.totalItemsProperty().bind(this.filteredTableView.totalItems());
    }

    @Nonnull
    private Predicate<HalfTrade> baseFilter() {
        return new IsOwnTradePredicate(this.tradeService).and(t -> !t.isRemoved());
    }

    private boolean disableTradeRecallButton() {
        return !this.tradeService.isTradeRecallPossible(this.getSelectedItems());
    }

    @FXML
    public void recallTradeButtonClickAction() {
        ObservableList tradeList = this.getSelectedItems();
        this.tradeService.recallTrades(tradeList, response -> {
            if (ResponseStatus.SUCCESS.equals((Object)response.getStatus())) {
                this.getAppContext().getService(UserAlertService.class).showConfirmationDialog(Util.getLabel("commons_recall"), Util.getLabel("tradeRecallPopup_info"), new UserAlertService.Flag[0]);
            }
        });
    }

    @Override
    public TradePanelState<HalfTrade> getComponentState() {
        return new TradePanelState<HalfTrade>(StorableTableLayoutDescriptor.fromTable(this.tradeTableView), this.menu.isExpanded(), this.bottomToolbar.getState(), this.filteredTableView.getCustomFilter().getFilterStates(), this.dateFilterComponent.getDateType(), this.dateFilterComponent.getOffsetInDays(), 0, 24, 24, false, this.showDecomposedTrades.getState());
    }

    @Override
    public void restoreComponentState(TradePanelState<HalfTrade> componentState) {
        super.restoreComponentState(componentState);
        this.filteredTableView.loadCustomFilter(componentState.getColumnFilters());
    }

    public static class IsOwnTradePredicate
    implements Predicate<HalfTrade> {
        private final TradeService tradeService;

        public IsOwnTradePredicate(TradeService tradeService) {
            this.tradeService = tradeService;
        }

        @Override
        public boolean test(@Nullable HalfTrade trade) {
            return trade != null && this.tradeService.isOwnBgTrade(trade);
        }
    }
}

