/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.ChartContractTreeContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.ChartMarketAreaChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.ChartMode;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.ChartRangeChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.LastTradeInfoText;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.PriceAndQuantityChart;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.TradeChartPanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.TradesChartModeChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbar;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.SlideInContractTreePane;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.SingleContractOrderbookEvent;
import com.deutscheboerse.comxerv.comtrader.jfx.util.DragAndDropService;
import com.deutscheboerse.comxerv.comtrader.service.PublicTradeConfirmationService;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.google.common.eventbus.Subscribe;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;

@DraggableComponent(hasPublicAccess=true, nameKey="tradesChartPanel_header_label", descriptionKey="tradesChartPanel_description")
@PanelWithLoadingIndicator(entityClasses={PublicTradeConfirmation.class})
public class TradesChartPanel
extends AbstractPanel
implements StorableComponent<TradeChartPanelState> {
    private static final String CHART_LABEL = Util.getLabel("commons_chart");
    private final DragAndDropService dragAndDropService;
    private final UserService userService;
    private final DataModelListener<Contract> contractDataModelListener;
    private final SlideInContractTreePane slideInContractTreePane;
    @FXML
    private BorderPane dropTarget;
    @FXML
    private PriceAndQuantityChart chart;
    @FXML
    private ChartRangeChoiceBox rangeChoiceBox;
    @FXML
    private ChartMarketAreaChoiceBox marketAreaChoiceBox;
    @FXML
    private TitledPane menu;
    @FXML
    private TradesChartModeChoiceBox modeChoiceBox;
    @FXML
    private LastTradeInfoText lastTradeInfo;
    @FXML
    private Node noContractSelectedPlaceholder;
    @FXML
    private Node notEnoughDataPlaceholder;
    @FXML
    private BottomToolbar bottomToolbar;
    private final ObjectProperty<Contract> contract;
    private final ObjectProperty<MarketArea> marketArea;
    private final DataModel<Long, Contract> contractDataModel;

    public TradesChartPanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected TradesChartPanel(ApplicationContext appContext) {
        super(appContext);
        this.contractDataModel = appContext.getDataModel(Contract.class);
        this.dragAndDropService = appContext.getService(DragAndDropService.class);
        this.userService = appContext.getService(UserService.class);
        this.contract = new SimpleObjectProperty<Contract>();
        this.marketArea = new SimpleObjectProperty<MarketArea>();
        this.contractDataModelListener = new AbstractDataModelListener<Contract>(){

            @Override
            public DataModelListener.NotificationResult notifyRemove(Contract contract) {
                if (contract.equals(TradesChartPanel.this.contract.get())) {
                    TradesChartPanel.this.setContract(null);
                }
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        };
        this.slideInContractTreePane = new SlideInContractTreePane(appContext, new ChartContractTreeContext(this::setContract));
        this.loadFxml();
        this.setLeft(this.slideInContractTreePane);
        appContext.getSmallDataModel(Contract.class).registerListener(new WeakDataModelListener<Contract>(this.contractDataModelListener));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.menu.textProperty().bind(DependentBinding.get(() -> CHART_LABEL + " " + ((ChartMode)this.modeChoiceBox.getValue()).getDisplayName(), this.modeChoiceBox.valueProperty()));
        if (this.userService.getOwnUser() != null && this.userService.getOwnUser().getExchange().supportsDeliveryAreas()) {
            this.marketAreaChoiceBox.applyDefaultValue();
        }
        this.dropTarget.setOnDragOver(event -> {
            Dragboard db = event.getDragboard();
            if (this.dragAndDropService.hasContractList(db)) {
                event.acceptTransferModes(TransferMode.ANY);
            }
            event.consume();
        });
        this.dropTarget.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            boolean anyContractsDropped = this.addDroppedContent(db);
            event.setDropCompleted(anyContractsDropped);
            event.consume();
        });
        this.contract.addListener(observable2 -> this.loadContent());
        this.marketArea.addListener(observable2 -> this.loadContent());
        this.rangeChoiceBox.valueProperty().addListener(observable2 -> this.loadContent());
        this.rangeChoiceBox.valueProperty().addListener(observable2 -> this.loadHistoricalTrades());
        this.chart.enoughTradesProperty().addListener(observable2 -> this.loadContent());
        this.chart.contractProperty().addListener(o -> this.loadLastTradeInfo());
        this.chart.contractProperty().addListener(observable2 -> this.loadHistoricalTrades());
        this.chart.marketAreaProperty().addListener(o -> this.loadLastTradeInfo());
        this.loadContent();
    }

    private void loadHistoricalTrades() {
        if (this.contract.get() != null) {
            this.getAppContext().getService(PublicTradeConfirmationService.class, ((Contract)this.contract.get()).getExchange()).loadPublicTradesTill(this.getAppContext().getService(TimeService.class).getServerTime().minusHours((Integer)this.rangeChoiceBox.getValue()));
        }
    }

    private boolean addDroppedContent(Dragboard db) {
        if (this.dragAndDropService.hasContractList(db)) {
            this.dragAndDropService.getContractList(db).forEach(this::setContract);
            return true;
        }
        return false;
    }

    private void loadContent() {
        boolean enoughTrades;
        boolean contractAndDASelected = this.contract.get() != null && this.marketArea != null;
        boolean bl = enoughTrades = contractAndDASelected && this.chart.isEnoughTrades() != false;
        if (contractAndDASelected && enoughTrades) {
            this.dropTarget.setCenter(this.chart);
        } else if (contractAndDASelected) {
            this.dropTarget.setCenter(this.notEnoughDataPlaceholder);
        } else {
            this.dropTarget.setCenter(this.noContractSelectedPlaceholder);
        }
    }

    private void loadLastTradeInfo() {
        this.lastTradeInfo.loadValues(this.chart.getLastTradeInfo());
    }

    @Subscribe
    public void handleMagnifierContractSelection(SingleContractOrderbookEvent event) {
        if (this.modeChoiceBox.getValue() == ChartMode.LINKED_MODE && Objects.equals(this.getContentTab(), this.getContentTabLookup().findContentTabOfNode(event.getEventSource()))) {
            this.marketAreaChoiceBox.setValue(event.getOrderbook().getDeliveryArea().getMarketArea());
            this.setContract(event.getOrderbook().getContract());
            event.markProcessed();
        }
    }

    @Override
    public TradeChartPanelState getComponentState() {
        Long contractId = this.contract.get() == null ? null : (Long)((Contract)this.contract.get()).getId();
        String maId = this.marketArea.get() == null ? null : (String)((MarketArea)this.marketArea.get()).getId();
        return new TradeChartPanelState(this.bottomToolbar.getState(), contractId, maId);
    }

    @Override
    public void restoreComponentState(TradeChartPanelState componentState) {
        Contract contractFoundById;
        Long contractId;
        this.bottomToolbar.applyToolbarItemState(componentState.getBottomToolbarStoredState());
        String maId = componentState.getMarketAreaId();
        if (maId != null) {
            this.marketAreaChoiceBox.setValueFromId(maId);
        }
        if ((contractId = componentState.getContractId()) != null && (contractFoundById = this.contractDataModel.findById(contractId)) != null && contractFoundById.getCompoundStatus().getContractStatus().isActive()) {
            this.setContract(contractFoundById);
        }
        this.loadHistoricalTrades();
    }

    public ChartMode getChartMode() {
        return (ChartMode)this.modeChoiceBox.getValue();
    }

    public Contract getContract() {
        return (Contract)this.contract.get();
    }

    public ObjectProperty<Contract> contractProperty() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract.set(contract);
    }

    public MarketArea getMarketArea() {
        return (MarketArea)this.marketArea.get();
    }

    public ObjectProperty<MarketArea> marketAreaProperty() {
        return this.marketArea;
    }

    public void setMarketArea(MarketArea marketArea) {
        this.marketArea.set(marketArea);
    }
}

