/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.chart;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.AxisWithPadding;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.BarXYChart;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.DateTimeAxisFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.LastTradeInfo;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.LongDisplayValueAxisFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.OpeningPriceChartSeries;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.TradeChartSeries;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.VBox;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class PriceAndQuantityChart
extends VBox {
    private static final int Y_AXIS_PREF_WIDTH = 75;
    private static final double GRAPH_X_PADDING_RELATIVE_TO_RANGE = 0.02;
    private final ObjectProperty<DateTimeZone> timeZone;
    private final ObjectProperty<Number> minXValue;
    private final ObjectProperty<Number> maxXValue;
    private final ObjectProperty<Contract> contract;
    private final ObjectProperty<MarketArea> marketArea;
    private final BooleanProperty enoughTrades;
    private final ObjectProperty<Integer> range;
    private final LineChart<Number, Number> priceChart;
    private final XYChart<Number, Number> quantityChart;
    private final TimeService timeService;
    private final ApplicationContext applicationContext;
    private TradeChartSeries quantitySeries;
    private TradeChartSeries allPriceSeries;
    private TradeChartSeries nonSelfTradePriceSeries;
    private TradeChartSeries selfTradePriceSeries;
    private OpeningPriceChartSeries openingPriceSeries;

    public PriceAndQuantityChart() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected PriceAndQuantityChart(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.timeService = applicationContext.getService(TimeService.class);
        this.timeZone = new SimpleObjectProperty<DateTimeZone>(DateTimeZone.UTC);
        this.minXValue = new SimpleObjectProperty<Integer>(0);
        this.maxXValue = new SimpleObjectProperty<Integer>(0);
        this.contract = new SimpleObjectProperty<Contract>();
        this.marketArea = new SimpleObjectProperty<MarketArea>();
        this.range = new SimpleObjectProperty<Integer>(1);
        this.enoughTrades = new SimpleBooleanProperty(false);
        DateTimeAxisFactory dateTimeAxisFactory = new DateTimeAxisFactory();
        NumberAxis priceXAxis = dateTimeAxisFactory.createDateTimeAxis(this.timeZone, false);
        NumberAxis priceYAxis = new LongDisplayValueAxisFactory().createLongDisplayValueAxis(this.contract, LongDisplayValueAxisFactory.PropertyType.PRICE);
        priceYAxis.setPrefWidth(75.0);
        DependentBinding<Number> minXValueWithRangeLimit = DependentBinding.get(this::getChartLowerBound, this.minXValue, this.maxXValue, this.range);
        new AxisWithPadding(priceXAxis, minXValueWithRangeLimit, this.maxXValue, 0.02);
        this.priceChart = new LineChart<Number, Number>(priceXAxis, priceYAxis);
        this.priceChart.setCreateSymbols(true);
        this.priceChart.setAnimated(false);
        this.priceChart.setLegendVisible(false);
        NumberAxis quantityYAxis = new LongDisplayValueAxisFactory().createLongDisplayValueAxis(this.contract, LongDisplayValueAxisFactory.PropertyType.QUANTITY);
        quantityYAxis.setForceZeroInRange(true);
        quantityYAxis.setPrefWidth(75.0);
        NumberAxis quantityXAxis = dateTimeAxisFactory.createDateTimeAxis(this.timeZone, true);
        new AxisWithPadding(quantityXAxis, minXValueWithRangeLimit, this.maxXValue, 0.02);
        this.quantityChart = new BarXYChart(quantityXAxis, quantityYAxis);
        this.quantityChart.setLegendVisible(false);
        this.marketArea.addListener(observable2 -> this.loadChartData());
        this.contract.addListener(observable2 -> this.loadChartData());
        this.getChildren().addAll((Node[])new Node[]{this.priceChart, this.quantityChart});
    }

    private void setHasEnoughTrades(Observable observable2) {
        if (this.quantitySeries != null && this.allPriceSeries != null) {
            if (!this.openingPriceSeries.asChartSeries().getData().isEmpty()) {
                this.enoughTrades.setValue(Boolean.TRUE);
            } else {
                long lowerBound = ((Number)this.minXValue.get()).longValue();
                ObservableList<XYChart.Data<Number, Number>> quantityData = this.quantitySeries.asChartSeries().getData();
                boolean hasEnoughTrades = quantityData.stream().mapToLong(dataPoint -> ((Number)dataPoint.getXValue()).longValue()).filter(xValue -> xValue >= lowerBound).count() > 1L;
                this.enoughTrades.setValue(hasEnoughTrades);
            }
        } else {
            this.enoughTrades.setValue(Boolean.FALSE);
        }
    }

    private void loadChartData() {
        Contract currentContract = (Contract)this.contract.get();
        MarketArea marketArea = (MarketArea)this.marketArea.get();
        if (currentContract != null && marketArea != null) {
            Exchange exchange = currentContract.getExchange();
            this.timeZone.setValue(exchange.getSystemInfo().getTimeZone());
            this.quantitySeries = new TradeChartSeries(this.applicationContext, currentContract, marketArea, PublicTradeConfirmation::getQuantity, t -> true, true);
            this.quantityChart.setData(FXCollections.singletonObservableList(this.quantitySeries.asChartSeries()));
            this.allPriceSeries = new TradeChartSeries(this.applicationContext, currentContract, marketArea, PublicTradeConfirmation::getPrice, t -> true, false);
            XYChart.Series<Number, Number> allPriceSeriesAsChartSeries = this.allPriceSeries.asChartSeries();
            this.nonSelfTradePriceSeries = new TradeChartSeries(this.applicationContext, currentContract, marketArea, PublicTradeConfirmation::getPrice, this::filterNonSelfTrades, false);
            XYChart.Series<Number, Number> nonSelfTradePriceSeriesAsChartSeries = this.nonSelfTradePriceSeries.asChartSeries();
            this.selfTradePriceSeries = new TradeChartSeries(this.applicationContext, currentContract, marketArea, PublicTradeConfirmation::getPrice, this::filterSelfTrades, false);
            XYChart.Series<Number, Number> selfTradePriceSeriesAsChartSeries = this.selfTradePriceSeries.asChartSeries();
            this.openingPriceSeries = new OpeningPriceChartSeries(this.applicationContext, currentContract, marketArea, this.allPriceSeries.minXValue());
            XYChart.Series<Number, Number> openingPriceSeriesAsChartSeries = this.openingPriceSeries.asChartSeries();
            this.priceChart.setData(FXCollections.observableArrayList(allPriceSeriesAsChartSeries, openingPriceSeriesAsChartSeries, nonSelfTradePriceSeriesAsChartSeries, selfTradePriceSeriesAsChartSeries));
            allPriceSeriesAsChartSeries.getData().addListener(this::setHasEnoughTrades);
            openingPriceSeriesAsChartSeries.getData().addListener(this::setHasEnoughTrades);
            nonSelfTradePriceSeriesAsChartSeries.getData().addListener(this::setHasEnoughTrades);
            selfTradePriceSeriesAsChartSeries.getData().addListener(this::setHasEnoughTrades);
            this.minXValue.bind(this.allPriceSeries.minXValue());
            this.maxXValue.bind(this.allPriceSeries.maxXValue());
        }
        this.setHasEnoughTrades(null);
    }

    private boolean filterSelfTrades(PublicTradeConfirmation publicTradeConfirmation) {
        return publicTradeConfirmation.isSelfTrade();
    }

    private boolean filterNonSelfTrades(PublicTradeConfirmation publicTradeConfirmation) {
        return !publicTradeConfirmation.isSelfTrade();
    }

    public Optional<LastTradeInfo> getLastTradeInfo() {
        if (this.getContract() != null && this.allPriceSeries != null && this.quantitySeries != null) {
            ObservableList<XYChart.Data<Number, Number>> prices = this.allPriceSeries.asChartSeries().getData();
            ObservableList<XYChart.Data<Number, Number>> quantities = this.quantitySeries.asChartSeries().getData();
            if (!prices.isEmpty() && !quantities.isEmpty()) {
                int lastPriceIndex = prices.size() - 1;
                int lastQuantityIndex = quantities.size() - 1;
                Product product = ((Contract)this.contract.getValue()).getProduct();
                LongDisplayValue price = new LongDisplayValue(((Number)((XYChart.Data)prices.get(lastPriceIndex)).getYValue()).longValue(), product.getPriceDecimalShift());
                LongDisplayValue quantity = new LongDisplayValue(((Number)((XYChart.Data)quantities.get(lastQuantityIndex)).getYValue()).longValue(), product.getQuantityDecimalShift());
                DateTime executionTime = DateTimeUtils.mapLongToDateTime(((Number)((XYChart.Data)prices.get(lastPriceIndex)).getXValue()).longValue(), this.getServerTime().getZone());
                return Optional.of(new LastTradeInfo(price, quantity, executionTime));
            }
        }
        return Optional.empty();
    }

    private long getChartLowerBound() {
        long currentRange = ((Integer)this.range.getValue()).intValue();
        long maxMinusRange = ((Number)this.maxXValue.get()).longValue() - currentRange * 3600000L;
        long min = ((Number)this.minXValue.get()).longValue();
        return Math.max(maxMinusRange, min);
    }

    private DateTime getServerTime() {
        return this.contract.get() != null ? this.timeService.getServerTime() : this.timeService.getLocalTime();
    }

    public Contract getContract() {
        return (Contract)this.contract.get();
    }

    public ObjectProperty<Contract> contractProperty() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract.set(contract);
    }

    public MarketArea getMarketArea() {
        return (MarketArea)this.marketArea.get();
    }

    public ObjectProperty<MarketArea> marketAreaProperty() {
        return this.marketArea;
    }

    public void setMarketArea(MarketArea marketArea) {
        this.marketArea.set(marketArea);
    }

    public Boolean isEnoughTrades() {
        return this.enoughTrades.get();
    }

    public ReadOnlyBooleanProperty enoughTradesProperty() {
        return this.enoughTrades;
    }

    public Integer getRange() {
        return (Integer)this.range.get();
    }

    public ObjectProperty<Integer> rangeProperty() {
        return this.range;
    }

    public void setRange(Integer range) {
        this.range.set(range);
    }
}

