/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.EntityWithNameAutoCompleteField;
import com.deutscheboerse.ui.jfx.util.control.AutoCompleteTextField;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractMemberField
extends EntityWithNameAutoCompleteField<Member> {
    protected final SmallFastDataModel<String, Member> memberDataModel;
    private BooleanProperty allowEmpty = new SimpleBooleanProperty(false);

    public AbstractMemberField(ApplicationContext appContext) {
        super(appContext);
        this.memberDataModel = appContext.getSmallDataModel(Member.class);
        this.setToStringConverter(Member::getDisplayName);
        this.valid.bind(this.valueProperty().isNotNull().or(this.allowEmpty));
    }

    protected abstract boolean filter(Member var1);

    @Override
    public Stream<Member> getSuggestedEntities(String currentText) {
        return this.memberDataModel.getAllEntitiesAsStream().filter((? super T member) -> this.getToStringConverter().apply((Member)member).toLowerCase().contains(currentText.toLowerCase())).filter(this::filter).sorted(new AutoCompleteTextField.ToStringConverterComparator(this.getToStringConverter()));
    }

    @Override
    public Optional<Member> getEntity(String currentText) {
        if (StringUtils.isNotEmpty(currentText)) {
            String id = this.getIdFromText(currentText);
            String name = this.getNameFromText(currentText);
            Member memberById = (Member)this.memberDataModel.findById(id);
            return Optional.ofNullable(memberById).filter((? super T member) -> name.equals(member.getName())).filter(this::filter);
        }
        return Optional.empty();
    }

    public boolean getAllowEmpty() {
        return this.allowEmpty.get();
    }

    public BooleanProperty allowEmptyProperty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty.set(allowEmpty);
    }
}

