/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.LargePersistableDataModel;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarCheckBox;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class DecomposedTradesChoiceBox
extends BottomToolbarCheckBox {
    private final ObjectProperty<Predicate<HalfTrade>> halfTraderFilter;
    private final ObjectProperty<Predicate<FullTrade>> fullTraderFilter;
    private final LargePersistableDataModel<Long, FullTrade> fullTradeDataModel;

    public DecomposedTradesChoiceBox() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public DecomposedTradesChoiceBox(ApplicationContext applicationContext) {
        this.fullTradeDataModel = applicationContext.getLargeDataModel(FullTrade.class);
        this.halfTraderFilter = new SimpleObjectProperty<Predicate<HalfTrade>>();
        this.fullTraderFilter = new SimpleObjectProperty<Predicate<FullTrade>>();
        this.halfTraderFilter.bind((ObservableValue<Predicate<HalfTrade>>)new DependentBinding<Predicate<HalfTrade>>(new Observable[]{this.selectedProperty()}){

            @Override
            protected Predicate<HalfTrade> computeValue() {
                return DecomposedTradesChoiceBox.this.isSelected() ? t -> true : t -> t.getParentTradeId() == null || DecomposedTradesChoiceBox.this.parentHalfTradeMisses((HalfTrade)t);
            }
        });
        this.fullTraderFilter.bind((ObservableValue<Predicate<FullTrade>>)new DependentBinding<Predicate<FullTrade>>(new Observable[]{this.selectedProperty()}){

            @Override
            protected Predicate<FullTrade> computeValue() {
                return DecomposedTradesChoiceBox.this.isSelected() ? t -> true : t -> t.getParentTradeId() == null;
            }
        });
        this.setSelected(true);
        this.setText(Util.getLabel("commons_decomposed"));
        this.setDescription(Util.getLabel("descriptions_toolbar_ownTradePanel_decomposed"));
    }

    private boolean parentHalfTradeMisses(HalfTrade halfTrade) {
        FullTrade parentTrade = (FullTrade)this.fullTradeDataModel.findById(halfTrade.getParentTradeId());
        return parentTrade == null || parentTrade.getHalf(halfTrade.getDirection()) == null;
    }

    public Predicate<HalfTrade> getHalfTraderFilter() {
        return (Predicate)this.halfTraderFilter.get();
    }

    public Predicate<FullTrade> getFullTraderFilter() {
        return (Predicate)this.fullTraderFilter.get();
    }

    public ObjectProperty<Predicate<FullTrade>> fullTraderFilterProperty() {
        return this.fullTraderFilter;
    }

    public ObjectProperty<Predicate<HalfTrade>> halfTraderFilterProperty() {
        return this.halfTraderFilter;
    }
}

