/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.control.AutoCompleteTextField;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public abstract class EntityAutoCompleteField<T>
extends AutoCompleteTextField<T> {
    private final ObjectProperty<T> value = new SimpleObjectProperty();
    private final ObservableValue<Exchange> activeExchange;
    private final InvalidationListener activeExchangeChange;

    protected EntityAutoCompleteField(ApplicationContext appContext) {
        super(Util.getLabel("commons_NoItemsAvailable"));
        this.textProperty().addListener(this.recomputeValueListener());
        this.activeExchange = appContext.getService(ActiveExchange.class).getActiveExchange();
        this.activeExchangeChange = change -> this.recomputeValueListener();
        this.activeExchange.addListener(new WeakInvalidationListener(this.activeExchangeChange));
    }

    protected InvalidationListener recomputeValueListener() {
        return observable2 -> this.value.setValue(this.getEntity(this.getText()).orElse(null));
    }

    @Override
    protected Stream<T> getSuggestions() {
        return this.getSuggestedEntities(Optional.ofNullable(this.getText()).orElse(""));
    }

    public abstract Stream<T> getSuggestedEntities(String var1);

    public abstract Optional<T> getEntity(String var1);

    public T getValue() {
        return this.value.get();
    }

    public ReadOnlyObjectProperty<T> valueProperty() {
        return this.value;
    }
}

