/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AlwaysTrueShowLoadingIndicatorRule;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ShowLoadingIndicatorRule;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingStartedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingStartedEvent;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.effect.DropShadow;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;

public class LoadingIndicator {
    private final List<Class<? extends BroadcastEntity>> entityClasses;
    private final Rectangle loadingModeIndicator;
    private final Label loadingLabel;
    private final BorderPane parent;
    private final ShowLoadingIndicatorRule showLoadingIndicatorRule;
    private final AtomicInteger currentlyLoadingClasses;
    private final ProgressIndicator progressIndicator;

    public LoadingIndicator(BorderPane parent, List<Class<? extends BroadcastEntity>> entityClasses) {
        this(parent, entityClasses, AlwaysTrueShowLoadingIndicatorRule.class);
    }

    public LoadingIndicator(BorderPane parent, List<Class<? extends BroadcastEntity>> entityClasses, Class<? extends ShowLoadingIndicatorRule> showLoadingIndicatorRuleClazz) {
        this.entityClasses = entityClasses;
        this.parent = parent;
        this.showLoadingIndicatorRule = this.createInstance(showLoadingIndicatorRuleClazz);
        this.currentlyLoadingClasses = new AtomicInteger(0);
        this.progressIndicator = new ProgressIndicator();
        this.progressIndicator.setProgress(-1.0);
        this.loadingLabel = new Label();
        this.loadingLabel.setGraphic(this.progressIndicator);
        this.loadingLabel.setText(Util.getLabel("dropTargetController_loading"));
        this.loadingLabel.layoutXProperty().bind(parent.widthProperty().divide(2).subtract(this.progressIndicator.widthProperty().get()));
        this.loadingLabel.layoutYProperty().bind(parent.heightProperty().divide(2));
        this.loadingLabel.setFont(new Font(25.0));
        this.loadingLabel.setEffect(new DropShadow(10.0, Color.LIGHTGRAY));
        this.loadingModeIndicator = new Rectangle();
        this.loadingModeIndicator.widthProperty().bind(parent.widthProperty());
        this.loadingModeIndicator.heightProperty().bind(parent.heightProperty());
        this.loadingModeIndicator.setFill(Color.LIGHTGRAY);
        this.loadingModeIndicator.setOpacity(0.7);
    }

    private ShowLoadingIndicatorRule createInstance(Class<? extends ShowLoadingIndicatorRule> showLoadingIndicatorRuleClazz) {
        try {
            return showLoadingIndicatorRuleClazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isLoadingIndicatorVisible() {
        return this.parent.getChildren().contains(this.loadingLabel);
    }

    @Subscribe
    public void handleEntityLoadingStarted(EntityLoadingStartedEvent entityLoadingStartedEvent) {
        if (this.entityClasses.contains(entityLoadingStartedEvent.getEntityClass()) && !this.currentlyLoadingClasses.compareAndSet(0, 1)) {
            this.currentlyLoadingClasses.incrementAndGet();
        }
    }

    @Subscribe
    public void handleLoadingStarted(LoadingStartedEvent loadingStartedEvent) {
        if (!(this.entityClasses.isEmpty() || loadingStartedEvent != null && !this.showLoadingIndicatorRule.evaluate(loadingStartedEvent.getSession()) || this.isLoadingIndicatorVisible())) {
            this.parent.getChildren().addAll((Node[])new Node[]{this.loadingModeIndicator, this.loadingLabel});
            this.fixSize();
        }
    }

    @Subscribe
    public void handleEntityLoadingFinished(EntityLoadingFinishedEvent entityLoadingFinishedEvent) {
        if (this.entityClasses.contains(entityLoadingFinishedEvent.getEntityClass())) {
            if (this.currentlyLoadingClasses.compareAndSet(1, 0)) {
                this.parent.getChildren().removeAll((Node[])new Node[]{this.loadingModeIndicator, this.loadingLabel});
                this.fixSize();
            } else {
                this.currentlyLoadingClasses.decrementAndGet();
            }
        }
    }

    private void fixSize() {
        FxUtil.runLater(() -> {
            this.loadingModeIndicator.setVisible(false);
            FxUtil.runLater(() -> this.loadingModeIndicator.setVisible(true));
        });
    }
}

