/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.web;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.net.URL;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.concurrent.Worker;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class ScrollAwareWebView
extends BorderPane {
    public static final int SCROLL_OVERLAP = 30;
    private final WebView webView;
    private final WebEngine engine;
    private final BooleanProperty finishedLoading;
    private final BooleanProperty canPageDown = new SimpleBooleanProperty(false);

    @Inject
    public ScrollAwareWebView(@Assisted URL url) {
        this.finishedLoading = new SimpleBooleanProperty(false);
        this.webView = new WebView();
        this.setCenter(this.webView);
        this.engine = this.webView.getEngine();
        this.engine.load(url.toString());
        this.finishedLoading.bind(this.engine.getLoadWorker().stateProperty().isEqualTo((Object)Worker.State.SUCCEEDED));
        this.finishedLoading.addListener(observable2 -> this.canPageDown.setValue(this.canPageDown()));
        this.webView.addEventFilter(ScrollEvent.SCROLL, (? super T event) -> this.canPageDown.setValue(this.canPageDown()));
    }

    public boolean canPageDown() {
        return this.scrollY() + this.viewportHeight() < this.scrollHeight();
    }

    public ReadOnlyBooleanProperty canPageDownProperty() {
        return this.canPageDown;
    }

    private int scrollY() {
        return (Integer)this.engine.executeScript("window.scrollY");
    }

    private int scrollHeight() {
        return (Integer)this.engine.executeScript("document.body.scrollHeight");
    }

    private int viewportHeight() {
        return (int)Math.round(this.getHeight());
    }

    public void pageDown() {
        int scrollBy = Math.max(this.viewportHeight() - 30, 1);
        this.engine.executeScript("window.scrollBy(0," + scrollBy + ")");
        this.canPageDown.setValue(this.canPageDown());
    }

    public Boolean isFinishedLoading() {
        return this.finishedLoading.get();
    }

    public ReadOnlyBooleanProperty finishedLoadingProperty() {
        return this.finishedLoading;
    }
}

