/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.eula;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.web.ScrollAwareWebView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.web.ScrollAwareWebViewFactory;
import com.deutscheboerse.comxerv.comtrader.service.EulaService;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import java.util.Locale;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.scene.control.Tab;

public class EulaTab
extends Tab {
    private final EulaService.Eula eula;
    private final ScrollAwareWebView eulaView;

    protected EulaTab(ApplicationContext applicationContext, EulaService.Eula eula) {
        this.eulaView = applicationContext.getService(ScrollAwareWebViewFactory.class).create(eula.getResource());
        this.eula = eula;
        Locale eulaLocale = eula.getLocale();
        this.setText(eulaLocale.getDisplayLanguage(eulaLocale) + " (" + eulaLocale.getDisplayLanguage(applicationContext.getService(LocalService.class).getConfiguredLocale()) + ")");
        this.setContent(this.eulaView);
    }

    public EulaService.Eula getEula() {
        return this.eula;
    }

    public ReadOnlyBooleanProperty canPageDownProperty() {
        return this.eulaView.canPageDownProperty();
    }

    public boolean canPageDown() {
        return this.eulaView.canPageDown();
    }

    public void pageDown() {
        this.eulaView.pageDown();
    }

    public ReadOnlyBooleanProperty finishedLoadingProperty() {
        return this.eulaView.finishedLoadingProperty();
    }

    public Boolean isFinishedLoading() {
        return this.eulaView.isFinishedLoading();
    }
}

