/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.image;

import com.deutscheboerse.comxerv.comtrader.core.util.DisplayImage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.scene.image.Image;

public class ImageFactory {
    private static final Map<String, Image> IMAGE_CACHE = new ConcurrentHashMap<String, Image>();
    private static final String PATH_FOR_NULL = "NULL";

    private ImageFactory() {
    }

    public static Image getImage(DisplayImage displayImage, String defaultImagePath) {
        String imagePath = displayImage == null || displayImage.getImagePath() == null ? PATH_FOR_NULL : displayImage.getImagePath();
        try {
            return IMAGE_CACHE.computeIfAbsent(imagePath, Image::new);
        }
        catch (IllegalArgumentException e) {
            Image defaultImage = IMAGE_CACHE.computeIfAbsent(defaultImagePath, Image::new);
            IMAGE_CACHE.put(imagePath, defaultImage);
            return defaultImage;
        }
    }

    public static Image getImage(String imagePath) {
        return imagePath != null ? IMAGE_CACHE.computeIfAbsent(imagePath, Image::new) : null;
    }

    static void clearCache() {
        IMAGE_CACHE.clear();
    }
}

