/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.layout;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ContentTab;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DropTargetParent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.SplitPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.PanelWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.util.DragAndDropService;
import java.util.Objects;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;

public class ComponentDroppedEventHandler
implements EventHandler<DragEvent> {
    private final ApplicationContext appContext;
    private final DragAndDropService dragAndDropService;
    private final Pos target;
    private final PanelWrapper panelWrapper;

    protected ComponentDroppedEventHandler(ApplicationContext appContext, PanelWrapper panelWrapper, Pos target) {
        this.appContext = appContext;
        this.panelWrapper = panelWrapper;
        this.dragAndDropService = appContext.getService(DragAndDropService.class);
        this.target = target;
    }

    @Override
    public void handle(DragEvent dragEvent) {
        Dragboard dragboard = dragEvent.getDragboard();
        PanelWrapper component = this.getComponent(dragboard);
        if (component == null) {
            return;
        }
        DropTargetParent parent = this.panelWrapper.getDropTargetParent();
        if (parent instanceof SplitPanel) {
            int index = ((SplitPanel)parent).getItems().indexOf(this.panelWrapper);
            this.addComponentToSplitPanel(component, (SplitPanel)parent, index);
        } else if (parent instanceof ContentTab) {
            this.addComponentToContentTab(component, (ContentTab)parent);
        } else {
            return;
        }
        if (dragEvent.getTransferMode() == TransferMode.MOVE && dragEvent.getGestureSource() instanceof Node) {
            this.removeDragSourceComponent((Node)dragEvent.getGestureSource());
        }
        dragEvent.setDropCompleted(true);
        dragEvent.consume();
    }

    private Node createNewContentRoot(Node oldNode, Node newNode) {
        switch (this.target) {
            case CENTER: {
                if (oldNode instanceof Destroyable) {
                    ((Destroyable)((Object)oldNode)).destroy();
                }
                SplitPanel newSplitPanel = new SplitPanel();
                newSplitPanel.getItems().add(newNode);
                return newSplitPanel;
            }
            case TOP_CENTER: {
                return this.createNewSplitPanelWithThis(Orientation.VERTICAL, newNode, oldNode);
            }
            case CENTER_RIGHT: {
                return this.createNewSplitPanelWithThis(Orientation.HORIZONTAL, oldNode, newNode);
            }
            case BOTTOM_CENTER: {
                return this.createNewSplitPanelWithThis(Orientation.VERTICAL, oldNode, newNode);
            }
            case CENTER_LEFT: {
                return this.createNewSplitPanelWithThis(Orientation.HORIZONTAL, newNode, oldNode);
            }
        }
        throw new IllegalArgumentException(Objects.toString((Object)this.target));
    }

    private void addComponentToSplitPanel(Node component, SplitPanel splitPanel, int index) {
        if (this.target == Pos.CENTER) {
            Node oldNode = (Node)splitPanel.getItems().get(index);
            if (oldNode instanceof Destroyable) {
                ((Destroyable)((Object)oldNode)).destroy();
            }
            splitPanel.addComponent(index, SplitPanel.InsertionMode.REPLACE, component);
        } else if (this.splitPanelOrientationMatches(splitPanel)) {
            splitPanel.addComponent(index, this.getInsertionMode(), component);
        } else if (this.getInsertionMode() == SplitPanel.InsertionMode.AFTER) {
            splitPanel.getItems().set(index, this.createNewSplitPanelWithThis(this.getOrientation(), this.panelWrapper, component));
        } else if (this.getInsertionMode() == SplitPanel.InsertionMode.BEFORE) {
            splitPanel.getItems().set(index, this.createNewSplitPanelWithThis(this.getOrientation(), component, this.panelWrapper));
        }
    }

    private boolean splitPanelOrientationMatches(SplitPanel splitPanel) {
        return splitPanel.getOrientation() == this.getOrientation();
    }

    private Orientation getOrientation() {
        if (this.target == Pos.TOP_CENTER || this.target == Pos.BOTTOM_CENTER) {
            return Orientation.VERTICAL;
        }
        if (this.target == Pos.CENTER_LEFT || this.target == Pos.CENTER_RIGHT) {
            return Orientation.HORIZONTAL;
        }
        throw new IllegalArgumentException();
    }

    private SplitPanel.InsertionMode getInsertionMode() {
        if (this.target == Pos.TOP_CENTER || this.target == Pos.CENTER_LEFT) {
            return SplitPanel.InsertionMode.BEFORE;
        }
        if (this.target == Pos.BOTTOM_CENTER || this.target == Pos.CENTER_RIGHT) {
            return SplitPanel.InsertionMode.AFTER;
        }
        return SplitPanel.InsertionMode.REPLACE;
    }

    private void removeDragSourceComponent(Node source) {
        if (source instanceof PanelWrapper) {
            ((PanelWrapper)source).getDropTargetParent().removeNode(source);
        } else if (source != null) {
            this.removeDragSourceComponent(source.getParent());
        }
    }

    private SplitPanel createNewSplitPanelWithThis(Orientation orientation, Node firstNode, Node secondNode) {
        SplitPanel newSplitPanel = new SplitPanel();
        newSplitPanel.setOrientation(orientation);
        newSplitPanel.getItems().addAll((Node[])new Node[]{firstNode, secondNode});
        return newSplitPanel;
    }

    private void addComponentToContentTab(Node component, ContentTab contentTab) {
        Node oldCenter;
        if (component instanceof PanelWrapper && ((PanelWrapper)component).isStoreable()) {
            contentTab.registerNewStorableComponent((StorableComponent)((Object)((PanelWrapper)component).getPanel()));
        }
        if ((oldCenter = contentTab.getContent()) == null) {
            contentTab.setContent(component);
        } else {
            contentTab.setContent(this.createNewContentRoot(oldCenter, component));
        }
    }

    private PanelWrapper getComponent(Dragboard dragboard) {
        if (this.dragAndDropService.hasComponent(dragboard)) {
            return new PanelWrapper(this.appContext, PanelFactory.createPanel(this.dragAndDropService.getComponent(dragboard), this.appContext));
        }
        if (this.dragAndDropService.hasComponentClassName(dragboard)) {
            return new PanelWrapper(this.appContext, PanelFactory.createPanel(this.dragAndDropService.getComponentClassName(dragboard), this.appContext));
        }
        return null;
    }
}

