/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.login;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParameters;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParametersWithFallback;
import com.deutscheboerse.comxerv.comtrader.entities.session.ProxyType;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.NumberTextField;
import com.deutscheboerse.comxerv.comtrader.jfx.util.converter.DisplayNameConverter;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.ProxySettings;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.binding.ValidProperty;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;

public class ProxySettingsPane
extends Pane {
    @FXML
    private ChoiceBox<ProxyType> proxyChoiceBox;
    @FXML
    private TextField proxyHostname;
    @FXML
    private TextField proxyUsername;
    @FXML
    private NumberTextField proxyPort;
    @FXML
    private PasswordField proxyPassword;
    private final ExecutorService loginTasksExecutor;
    private ValidProperty proxyHostValid;
    private ValidProperty proxyPortValid;
    private final ProxySettings proxySettings;

    public ProxySettingsPane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected ProxySettingsPane(ApplicationContext applicationContext) {
        this.proxySettings = applicationContext.getService(ProxySettings.class);
        this.loginTasksExecutor = applicationContext.getService(ExecutorService.class, WorkerExecutor.class);
        FXMLLoaderWithContext.loadCustomComponent(applicationContext, this);
    }

    public void initialize() {
        this.proxyChoiceBox.setItems(FXCollections.observableArrayList(ProxyType.NO_PROXY, ProxyType.HTTP, ProxyType.SOCKS));
        this.proxyChoiceBox.setConverter(new DisplayNameConverter());
        this.proxyPort.textProperty().addListener(this::proxyPortChanged);
        this.proxyHostname.textProperty().addListener(this::proxyHostChanged);
        if (this.proxyChoiceBox.getItems().contains(this.proxySettings.getProxyType())) {
            this.proxyChoiceBox.getSelectionModel().select(this.proxySettings.getProxyType());
        } else {
            this.proxyChoiceBox.getSelectionModel().selectFirst();
        }
        this.proxyHostValid = new ValidProperty(this.proxyHostname);
        this.proxyPortValid = new ValidProperty(this.proxyPort);
        this.proxyHostname.setText(this.proxySettings.getProxyHostname());
        this.proxyPort.setText(this.proxySettings.getProxyPort());
        this.proxyUsername.setText(this.proxySettings.getProxyUsername());
        this.proxyPassword.setText(this.proxySettings.getProxyPassword());
        BooleanBinding noProxyBinding = Bindings.equal(this.proxyChoiceBox.valueProperty(), ProxyType.NO_PROXY).or(Bindings.equal(this.proxyChoiceBox.valueProperty(), ProxyType.LEASED));
        this.proxyHostname.disableProperty().bind(noProxyBinding);
        this.proxyPort.disableProperty().bind(noProxyBinding);
        this.proxyUsername.disableProperty().bind(noProxyBinding);
        this.proxyPassword.disableProperty().bind(noProxyBinding);
        this.proxySettings.proxyTypeProperty().bind(this.proxyChoiceBox.valueProperty());
        this.proxySettings.proxyHostnameProperty().bind(this.proxyHostname.textProperty());
        this.proxySettings.proxyPortProperty().bind(this.proxyPort.textProperty());
        this.proxySettings.proxyUsernameProperty().bind(this.proxyUsername.textProperty());
        this.proxySettings.proxyPasswordProperty().bind(this.proxyPassword.textProperty());
    }

    protected void loadConnectionParameters(ConnectionParametersWithFallback connectionParameters) {
        if (connectionParameters.getConnectionParameters().stream().anyMatch(ConnectionParameters::getLeasedLine)) {
            this.proxyChoiceBox.getItems().add(ProxyType.LEASED);
        }
        connectionParameters.useLeasedLineProperty().bind(Bindings.equal(this.proxyChoiceBox.valueProperty(), ProxyType.LEASED));
    }

    private void proxyPortChanged(ObservableValue<? extends String> observable2, String oldValue, String newValue) {
        try {
            int port = Integer.parseInt(newValue);
            this.proxyPortValid.setValue(port >= 0 && port <= 65535);
        }
        catch (NumberFormatException e) {
            this.proxyPortValid.setValue(false);
        }
    }

    private void proxyHostChanged(ObservableValue<? extends String> observable2, String oldValue, String newValue) {
        this.loginTasksExecutor.submit(() -> {
            try {
                boolean hostInvalid = new InetSocketAddress(newValue, 0).isUnresolved();
                FxUtil.runInFxThread(() -> this.proxyHostValid.setValue(!hostInvalid));
            }
            catch (Exception e) {
                FxUtil.runInFxThread(() -> this.proxyHostValid.setValue(false));
            }
        });
    }

    public ChoiceBox<ProxyType> getProxyChoiceBox() {
        return this.proxyChoiceBox;
    }
}

