/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.login;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParametersWithFallback;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.model.SecurityType;
import com.deutscheboerse.comxerv.comtrader.jfx.util.converter.DisplayNameConverter;
import com.deutscheboerse.comxerv.comtrader.util.AesEncrypt;
import com.deutscheboerse.ui.jfx.util.ModalStages;
import java.io.File;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class SecurityPane
extends GridPane {
    @FXML
    private ChoiceBox<SecurityType> securityChoiceBox;
    @FXML
    private TextField certPath;
    @FXML
    private PasswordField certPassword;
    @FXML
    private Button certButton;

    public SecurityPane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public SecurityPane(ApplicationContext applicationContext) {
        FXMLLoaderWithContext.loadCustomComponent(applicationContext, this);
    }

    protected void loadConnectionParameters(ConnectionParametersWithFallback connectionParameters, BooleanProperty disableLoginControls, SecurityType securityType) {
        if (connectionParameters.isOwnCertificateEnabled()) {
            connectionParameters.setUseOwnCertificate(SecurityType.OVERRIDE == securityType);
            BooleanBinding disableCertEditing = this.securityChoiceBox.valueProperty().isEqualTo(SecurityType.USE_STORED).or(disableLoginControls);
            this.certPath.disableProperty().bind(disableCertEditing);
            this.certButton.disableProperty().bind(disableCertEditing);
            this.certPassword.disableProperty().bind(disableCertEditing);
            this.securityChoiceBox.disableProperty().bind(disableLoginControls);
            this.securityChoiceBox.setValue(securityType);
        }
        this.securityChoiceBox.setItems(FXCollections.observableArrayList(SecurityType.values()));
        this.securityChoiceBox.setConverter(new DisplayNameConverter());
    }

    @FXML
    public void chooseFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("SSL certificates (*.p12)", "*.p12"));
        Stage chooseFileStage = new Stage(StageStyle.UTILITY);
        ModalStages.makeModal(chooseFileStage);
        File file = fileChooser.showOpenDialog(chooseFileStage);
        if (file != null) {
            this.certPath.setText(file.getAbsolutePath());
        }
    }

    protected void reset(ConnectionParametersWithFallback connectionParameters) {
        if (connectionParameters.isOwnCertificateEnabled()) {
            this.securityChoiceBox.setValue(SecurityType.USE_STORED);
            this.certPassword.setText("");
        }
    }

    protected void setConnectionParametersValues(ConnectionParametersWithFallback connectionParameters, char[] singlePasswordText) {
        connectionParameters.setUseOwnCertificate(this.securityChoiceBox.getValue() == SecurityType.OVERRIDE);
        if (this.securityChoiceBox.getValue() == SecurityType.OVERRIDE) {
            connectionParameters.setUseOwnCertificate(true);
            connectionParameters.setCertificatePath(this.certPath.getText());
            connectionParameters.setCertificatePassword(AesEncrypt.encrypt(singlePasswordText, this.certPassword.getText()));
        }
    }
}

