/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AbstractProductAwareLongDisplayValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderBindingUtil;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.PriceField;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;

public class LimitlessPriceField
extends AbstractProductAwareLongDisplayValueField {
    public LimitlessPriceField() {
    }

    public LimitlessPriceField(LongDisplayValue initialValue) {
        super(initialValue);
    }

    public LimitlessPriceField(LongDisplayValue initialValue, int delta) {
        super(initialValue, delta);
    }

    public void init(ObservableObjectValue<Contract> contract) {
        this.productProperty().bind(OrderBindingUtil.productBinding(contract));
        this.textFieldFocusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (contract.get() != null) {
                Product product = ((Contract)contract.get()).getProduct();
                int decimalShift = product.getPriceDecimalShift();
                int tickSize = (int)product.getPriceTickSize().getValue();
                if (!oldValue.booleanValue() && newValue.booleanValue() || this.isValid()) {
                    LongDisplayValue oldPrice = this.getValue();
                    if (oldPrice != null) {
                        this.setValue(oldPrice.applyShift(decimalShift));
                    }
                    this.setDelta(tickSize);
                    this.selectAllIfFocused();
                }
                if (this.getValue() != null && oldValue.booleanValue() && !newValue.booleanValue()) {
                    this.setValue(this.getValue().applyShift(decimalShift));
                }
            }
        });
    }

    @Override
    public LongDisplayValue getInitialValue() {
        return LongDisplayValue.ZERO.applyShift(this.getProduct().getPriceDecimalShift());
    }

    @Override
    public Node getPreviewForConfigTable() {
        PriceField simpleLongDisplayValueField = new PriceField(this.getValue());
        simpleLongDisplayValueField.setValue(this.getValue());
        simpleLongDisplayValueField.prefWidthProperty().bind(this.widthProperty());
        simpleLongDisplayValueField.setDisable(true);
        return simpleLongDisplayValueField;
    }
}

