/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry;

import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.StyleService;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderModificationErrorDialog;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSender;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrdersToSend;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Inject;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;

public class OrderModificationErrorDialogImpl
extends Dialog<FailedModificationAction>
implements OrderModificationErrorDialog {
    public static final int PREF_MESSAGE_WIDTH = 200;
    private final StyleService styleService;
    private final OrderPopup orderPopup;
    private final OrderSender orderSender;
    private final ButtonType okButton;
    private final ButtonType prefillButton;
    private final ButtonType resendButton;

    @Inject
    public OrderModificationErrorDialogImpl(StyleService styleService, OrderPopup orderPopup, OrderSender orderSender) {
        Node resendButtonNode;
        Node prefillButtonNode;
        this.styleService = styleService;
        this.orderPopup = orderPopup;
        this.orderSender = orderSender;
        this.setResultConverter(this::convertResult);
        this.okButton = new ButtonType(FailedModificationAction.DO_NOTING.getDisplayName(), ButtonBar.ButtonData.OK_DONE);
        this.prefillButton = new ButtonType(FailedModificationAction.PREFILL.getDisplayName(), ButtonBar.ButtonData.OTHER);
        this.resendButton = new ButtonType(FailedModificationAction.RESEND.getDisplayName(), ButtonBar.ButtonData.OTHER);
        this.getDialogPane().getButtonTypes().addAll((ButtonType[])new ButtonType[]{this.okButton, this.prefillButton, this.resendButton});
        this.getDialogPane().getStyleClass().add("jfxDialog");
        Node okButtonNode = this.getDialogPane().lookupButton(this.okButton);
        if (okButtonNode instanceof Labeled) {
            ((Labeled)okButtonNode).setGraphic(new IconView("button-ok"));
        }
        if ((prefillButtonNode = this.getDialogPane().lookupButton(this.prefillButton)) instanceof Labeled) {
            ((Labeled)prefillButtonNode).setGraphic(new IconView("button-modify"));
        }
        if ((resendButtonNode = this.getDialogPane().lookupButton(this.resendButton)) instanceof Labeled) {
            ((Labeled)resendButtonNode).setGraphic(new IconView("button-play"));
        }
    }

    private FailedModificationAction convertResult(ButtonType buttonType) {
        if (buttonType == this.okButton) {
            return FailedModificationAction.DO_NOTING;
        }
        if (buttonType == this.prefillButton) {
            return FailedModificationAction.PREFILL;
        }
        if (buttonType == this.resendButton) {
            return FailedModificationAction.RESEND;
        }
        return null;
    }

    @Override
    public void orderModificationFailed(Order order, AsyncResponse asyncResponse) {
        this.styleService.registerSceneForStyleSwitching(this.getDialogPane().getScene());
        Label message = new Label(asyncResponse.getMessage());
        message.setWrapText(true);
        message.setPrefWidth(200.0);
        this.getDialogPane().setContent(message);
        message.applyCss();
        message.setPrefHeight(message.prefHeight(200.0));
        this.setHeaderText(Util.getLabel("orderModificationErrorDialog_header"));
        FailedModificationAction userAction = this.getUserAction();
        if (userAction == FailedModificationAction.PREFILL) {
            this.orderPopup.showExtendedOrderPopup(order, false, this.getDialogPane());
        } else if (userAction == FailedModificationAction.RESEND) {
            this.orderSender.sendOrder(new OrdersToSend(order, RequestType.MODIFY));
        }
        this.close();
    }

    protected FailedModificationAction getUserAction() {
        return this.showAndWait().orElse(FailedModificationAction.DO_NOTING);
    }

    protected static enum FailedModificationAction implements DisplayName
    {
        RESEND("commons_resend"),
        PREFILL("commons_prefill"),
        DO_NOTING("commons_ok");

        private final String labelKey;

        private FailedModificationAction(String labelKey) {
            this.labelKey = labelKey;
        }

        @Override
        public String getDisplayName() {
            return Util.getLabel(this.labelKey);
        }
    }
}

