/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.settings;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelProductListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.NumberTextField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.alerting.AlertingColorPicker;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.AlertingSettingEntry;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.SettingsSection;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingColor;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingService;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingSetting;
import javafx.beans.binding.Bindings;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;

public class AlertingSettingsPane
extends ScrollPane
implements SettingsSection {
    private final ApplicationContext appContext;
    private final AlertingService alertingService;
    private final DataModelProductListener productDataModelListener;
    @FXML
    private NumberTextField alertingTimer;
    @FXML
    private AlertingColorPicker alertingColor;
    @FXML
    private VBox alteringEventContainer;
    private final ObservableList<AlertingSettingEntry> alertingSettingsEntries;

    public AlertingSettingsPane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public AlertingSettingsPane(ApplicationContext appContext) {
        this.appContext = appContext;
        this.alertingService = appContext.getService(AlertingService.class);
        this.alertingSettingsEntries = FXCollections.observableArrayList();
        this.productDataModelListener = new DataModelProductListener(this::productAdded, this::productRemoved, this::removeAll);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        Bindings.bindContent(this.alteringEventContainer.getChildren(), this.alertingSettingsEntries);
        appContext.getSmallDataModel(Product.class).registerListener(new WeakDataModelListener<Product>(this.productDataModelListener));
    }

    @Override
    public boolean applyChanges() {
        this.alertingSettingsEntries.stream().map(e -> new AlertingSetting(e.getProductId(), e.getEnabled(), e.getAlertingTimer(), e.getAlertingColor())).forEach(this.alertingService::saveAlertingSettings);
        return true;
    }

    @Override
    public void cancelChanges() {
    }

    @Override
    public void resetToDefault() {
        this.alertingTimer.setText("0");
        this.alertingColor.setValue(AlertingColor.DEFAULT);
        this.alertingSettingsEntries.forEach(entry -> {
            entry.disable();
            entry.setAlertingTimer("0");
            entry.setAlertingColor(AlertingColor.DEFAULT);
        });
    }

    private void productAdded(Product product) {
        if (this.alertingSettingsEntries.stream().map(AlertingSettingEntry::getProductId).filter(entryProductId -> entryProductId.equals(product.getId())).findFirst().orElse(null) == null) {
            this.alertingSettingsEntries.add(new AlertingSettingEntry(this.appContext, (String)product.getId(), product.getDisplayName(), this.alertingService.getAlertingSettings((String)product.getId())));
        }
    }

    private void productRemoved(Product product) {
        this.alertingSettingsEntries.stream().filter(entry -> product.getName().equals(entry.getProductName())).findFirst().ifPresent(this.alertingSettingsEntries::remove);
    }

    private void removeAll() {
        this.alertingSettingsEntries.removeAll((AlertingSettingEntry[])new AlertingSettingEntry[0]);
    }

    @FXML
    public void enableAll() {
        this.alertingSettingsEntries.stream().forEach(AlertingSettingEntry::enable);
    }

    @FXML
    public void disableAll() {
        this.alertingSettingsEntries.stream().forEach(AlertingSettingEntry::disable);
    }

    @FXML
    public void applyTimer() {
        this.alertingSettingsEntries.stream().forEach(entry -> entry.setAlertingTimer(this.alertingTimer.getText()));
    }

    @FXML
    public void applyColor() {
        this.alertingSettingsEntries.stream().forEach(entry -> entry.setAlertingColor(this.alertingColor.getValue()));
    }
}

